/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.benchmark.ec2;

import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import software.amazon.awssdk.benchmark.ec2.V2ItemFactory;
import software.amazon.awssdk.protocols.query.AwsEc2ProtocolFactory;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.services.ec2.model.RunInstancesRequest;
import software.amazon.awssdk.services.ec2.transform.RunInstancesRequestMarshaller;

public class V2Ec2MarshallerBenchmark {
    private static final AwsEc2ProtocolFactory PROTOCOL_FACTORY = AwsEc2ProtocolFactory.builder().build();
    private static final RunInstancesRequestMarshaller RUN_INSTANCES_REQUEST_MARSHALLER = new RunInstancesRequestMarshaller((AwsQueryProtocolFactory)PROTOCOL_FACTORY);

    @Benchmark
    public Object marshall(MarshallerState s) {
        return V2Ec2MarshallerBenchmark.runInstancesRequestMarshaller().marshall(s.getReq());
    }

    private static RunInstancesRequestMarshaller runInstancesRequestMarshaller() {
        return RUN_INSTANCES_REQUEST_MARSHALLER;
    }

    public static enum TestItem {
        TINY,
        SMALL,
        HUGE;

        private static final V2ItemFactory FACTORY;
        private RunInstancesRequest request;

        public RunInstancesRequest getValue() {
            return this.request;
        }

        static {
            FACTORY = new V2ItemFactory();
            TestItem.TINY.request = FACTORY.tiny();
            TestItem.SMALL.request = FACTORY.small();
            TestItem.HUGE.request = FACTORY.huge();
        }
    }

    @State(value=Scope.Benchmark)
    public static class MarshallerState {
        @Param(value={"TINY", "SMALL", "HUGE"})
        private TestItem testItem;
        private RunInstancesRequest req;

        @Setup
        public void setup() {
            this.req = this.testItem.getValue();
        }

        public RunInstancesRequest getReq() {
            return this.req;
        }
    }
}

