/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.benchmark.ec2;

import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.CpuOptionsRequest;
import com.amazonaws.services.ec2.model.EbsBlockDevice;
import com.amazonaws.services.ec2.model.ElasticGpuSpecification;
import com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification;
import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.amazonaws.services.ec2.model.VolumeType;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

final class V1ItemFactory {
    private static final String ALPHA = "abcdefghijklmnopqrstuvwxyz";
    private static final Random RNG = new Random();

    V1ItemFactory() {
    }

    RunInstancesRequest tiny() {
        return new RunInstancesRequest().withAdditionalInfo(V1ItemFactory.randomS(50)).withDisableApiTermination(Boolean.valueOf(true)).withMaxCount(Integer.valueOf(5));
    }

    RunInstancesRequest small() {
        return new RunInstancesRequest().withAdditionalInfo(V1ItemFactory.randomS(50)).withDisableApiTermination(Boolean.valueOf(true)).withMaxCount(Integer.valueOf(5)).withBlockDeviceMappings(V1ItemFactory.blockDeviceMappings(3)).withCpuOptions(new CpuOptionsRequest().withCoreCount(Integer.valueOf(5)).withThreadsPerCore(Integer.valueOf(5))).withElasticGpuSpecification(new ElasticGpuSpecification[]{new ElasticGpuSpecification().withType(V1ItemFactory.randomS(50))}).withNetworkInterfaces(V1ItemFactory.networkInterfaces(3));
    }

    RunInstancesRequest huge() {
        return new RunInstancesRequest().withAdditionalInfo(V1ItemFactory.randomS(50)).withDisableApiTermination(Boolean.valueOf(true)).withMaxCount(Integer.valueOf(5)).withBlockDeviceMappings(V1ItemFactory.blockDeviceMappings(100)).withCpuOptions(new CpuOptionsRequest().withCoreCount(Integer.valueOf(5)).withThreadsPerCore(Integer.valueOf(5))).withElasticGpuSpecification(new ElasticGpuSpecification[]{new ElasticGpuSpecification().withType(V1ItemFactory.randomS(50))}).withNetworkInterfaces(V1ItemFactory.networkInterfaces(100));
    }

    static InstanceNetworkInterfaceSpecification networkInterface() {
        return new InstanceNetworkInterfaceSpecification().withAssociatePublicIpAddress(Boolean.valueOf(true)).withDeleteOnTermination(Boolean.valueOf(true)).withDeviceIndex(Integer.valueOf(50)).withGroups(new String[]{V1ItemFactory.randomS(50), V1ItemFactory.randomS(50), V1ItemFactory.randomS(50)}).withDescription(V1ItemFactory.randomS(50));
    }

    static List<InstanceNetworkInterfaceSpecification> networkInterfaces(int num) {
        return IntStream.of(num).mapToObj(i -> V1ItemFactory.networkInterface()).collect(Collectors.toList());
    }

    private static BlockDeviceMapping blockDeviceMapping() {
        return new BlockDeviceMapping().withDeviceName(V1ItemFactory.randomS(100)).withVirtualName(V1ItemFactory.randomS(50)).withNoDevice(V1ItemFactory.randomS(50)).withEbs(new EbsBlockDevice().withDeleteOnTermination(Boolean.valueOf(true)).withEncrypted(Boolean.valueOf(false)).withIops(Integer.valueOf(50)).withKmsKeyId(V1ItemFactory.randomS(50)).withSnapshotId(V1ItemFactory.randomS(50)).withVolumeSize(Integer.valueOf(50)).withVolumeType(VolumeType.Gp2));
    }

    private static List<BlockDeviceMapping> blockDeviceMappings(int num) {
        return IntStream.of(num).mapToObj(i -> V1ItemFactory.blockDeviceMapping()).collect(Collectors.toList());
    }

    private static String randomS(int len) {
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            sb.append(ALPHA.charAt(RNG.nextInt(ALPHA.length())));
        }
        return sb.toString();
    }
}

