/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.benchmark.ec2;

import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.amazonaws.services.ec2.model.transform.RunInstancesRequestMarshaller;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import software.amazon.awssdk.benchmark.ec2.V1ItemFactory;

public class V1Ec2MarshallerBenchmark {
    private static final RunInstancesRequestMarshaller RUN_INSTANCES_REQUEST_MARSHALLER = new RunInstancesRequestMarshaller();

    @Benchmark
    public Object marshall(MarshallerState s) {
        return V1Ec2MarshallerBenchmark.runInstancesRequestMarshaller().marshall(s.getReq());
    }

    private static RunInstancesRequestMarshaller runInstancesRequestMarshaller() {
        return RUN_INSTANCES_REQUEST_MARSHALLER;
    }

    public static enum TestItem {
        TINY,
        SMALL,
        HUGE;

        private static final V1ItemFactory FACTORY;
        private RunInstancesRequest request;

        public RunInstancesRequest getValue() {
            return this.request;
        }

        static {
            FACTORY = new V1ItemFactory();
            TestItem.TINY.request = FACTORY.tiny();
            TestItem.SMALL.request = FACTORY.small();
            TestItem.HUGE.request = FACTORY.huge();
        }
    }

    @State(value=Scope.Benchmark)
    public static class MarshallerState {
        @Param(value={"TINY", "SMALL", "HUGE"})
        private TestItem testItem;
        private RunInstancesRequest req;

        @Setup
        public void setup() {
            this.req = this.testItem.getValue();
        }

        public RunInstancesRequest getReq() {
            return this.req;
        }
    }
}

