/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.benchmark.dynamodb;

import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.Request;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.GetItemResult;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.transform.GetItemResultJsonUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.PutItemRequestProtocolMarshaller;
import com.amazonaws.transform.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Map;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import software.amazon.awssdk.benchmark.dynamodb.AbstractItemFactory;
import software.amazon.awssdk.benchmark.dynamodb.V1ItemFactory;

@State(value=Scope.Benchmark)
public class V1DynamoDbAttributeValue {
    private static final SdkJsonProtocolFactory PROTOCOL_FACTORY = V1DynamoDbAttributeValue.protocolFactory();
    private static final PutItemRequestProtocolMarshaller PUT_ITEM_REQUEST_MARSHALLER = new PutItemRequestProtocolMarshaller(PROTOCOL_FACTORY);

    @Benchmark
    public Object putItem(PutItemState s) {
        return PUT_ITEM_REQUEST_MARSHALLER.marshall(s.getReq());
    }

    @Benchmark
    public Object getItem(GetItemState s) {
        HttpResponse resp = new HttpResponse(null, null);
        resp.setContent((InputStream)new ByteArrayInputStream(s.testItem.utf8()));
        try {
            return V1DynamoDbAttributeValue.getItemJsonResponseHandler().handle(resp);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] toUtf8ByteArray(Map<String, AttributeValue> item) {
        Request resp = PUT_ITEM_REQUEST_MARSHALLER.marshall(new PutItemRequest().withItem(item));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buff = new byte[8192];
        try {
            int read;
            while ((read = resp.getContent().read(buff)) != -1) {
                baos.write(buff, 0, read);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return baos.toByteArray();
    }

    private static HttpResponseHandler<AmazonWebServiceResponse<GetItemResult>> getItemJsonResponseHandler() {
        return PROTOCOL_FACTORY.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetItemResultJsonUnmarshaller());
    }

    private static SdkJsonProtocolFactory protocolFactory() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.0").withSupportsCbor(false).withSupportsIon(false));
    }

    public static enum TestItemUnmarshalling {
        TINY,
        SMALL,
        HUGE;

        private byte[] utf8;

        public byte[] utf8() {
            return this.utf8;
        }

        static {
            TestItemUnmarshalling.TINY.utf8 = V1DynamoDbAttributeValue.toUtf8ByteArray(TestItem.TINY.av);
            TestItemUnmarshalling.SMALL.utf8 = V1DynamoDbAttributeValue.toUtf8ByteArray(TestItem.SMALL.av);
            TestItemUnmarshalling.HUGE.utf8 = V1DynamoDbAttributeValue.toUtf8ByteArray(TestItem.HUGE.av);
        }
    }

    public static enum TestItem {
        TINY,
        SMALL,
        HUGE;

        private static final AbstractItemFactory<AttributeValue> FACTORY;
        private Map<String, AttributeValue> av;

        public Map<String, AttributeValue> getValue() {
            return this.av;
        }

        static {
            FACTORY = new V1ItemFactory();
            TestItem.TINY.av = FACTORY.tiny();
            TestItem.SMALL.av = FACTORY.small();
            TestItem.HUGE.av = FACTORY.huge();
        }
    }

    @State(value=Scope.Benchmark)
    public static class GetItemState {
        @Param(value={"TINY", "SMALL", "HUGE"})
        private TestItemUnmarshalling testItem;
    }

    @State(value=Scope.Benchmark)
    public static class PutItemState {
        @Param(value={"TINY", "SMALL", "HUGE"})
        private TestItem testItem;
        private PutItemRequest req;

        @Setup
        public void setup() {
            this.req = new PutItemRequest().withItem(this.testItem.getValue());
        }

        public PutItemRequest getReq() {
            return this.req;
        }
    }
}

