/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.schemas.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.schemas.SchemasAsyncClient;
import software.amazon.awssdk.services.schemas.model.ListRegistriesRequest;
import software.amazon.awssdk.services.schemas.model.ListRegistriesResponse;
import software.amazon.awssdk.services.schemas.model.RegistrySummary;

public class ListRegistriesPublisher
implements SdkPublisher<ListRegistriesResponse> {
    private final SchemasAsyncClient client;
    private final ListRegistriesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRegistriesPublisher(SchemasAsyncClient client, ListRegistriesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRegistriesPublisher(SchemasAsyncClient client, ListRegistriesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRegistriesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRegistriesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RegistrySummary> registries() {
        Function<ListRegistriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.registries() != null) {
                return response.registries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRegistriesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRegistriesResponseFetcher
    implements AsyncPageFetcher<ListRegistriesResponse> {
        private ListRegistriesResponseFetcher() {
        }

        public boolean hasNextPage(ListRegistriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRegistriesResponse> nextPage(ListRegistriesResponse previousPage) {
            if (previousPage == null) {
                return ListRegistriesPublisher.this.client.listRegistries(ListRegistriesPublisher.this.firstRequest);
            }
            return ListRegistriesPublisher.this.client.listRegistries((ListRegistriesRequest)((Object)ListRegistriesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

