/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.schemas.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CodeGenerationStatus {
    CREATE_IN_PROGRESS("CREATE_IN_PROGRESS"),
    CREATE_COMPLETE("CREATE_COMPLETE"),
    CREATE_FAILED("CREATE_FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CodeGenerationStatus> VALUE_MAP;
    private final String value;

    private CodeGenerationStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CodeGenerationStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CodeGenerationStatus> knownValues() {
        EnumSet<CodeGenerationStatus> knownValues = EnumSet.allOf(CodeGenerationStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CodeGenerationStatus.class, CodeGenerationStatus::toString);
    }
}

