/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.schemas.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.schemas.SchemasClient;
import software.amazon.awssdk.services.schemas.internal.UserAgentUtils;
import software.amazon.awssdk.services.schemas.model.SearchSchemaSummary;
import software.amazon.awssdk.services.schemas.model.SearchSchemasRequest;
import software.amazon.awssdk.services.schemas.model.SearchSchemasResponse;

public class SearchSchemasIterable
implements SdkIterable<SearchSchemasResponse> {
    private final SchemasClient client;
    private final SearchSchemasRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchSchemasIterable(SchemasClient client, SearchSchemasRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchSchemasResponseFetcher();
    }

    public Iterator<SearchSchemasResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SearchSchemaSummary> schemas() {
        Function<SearchSchemasResponse, Iterator> getIterator = response -> {
            if (response != null && response.schemas() != null) {
                return response.schemas().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchSchemasResponseFetcher
    implements SyncPageFetcher<SearchSchemasResponse> {
        private SearchSchemasResponseFetcher() {
        }

        public boolean hasNextPage(SearchSchemasResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchSchemasResponse nextPage(SearchSchemasResponse previousPage) {
            if (previousPage == null) {
                return SearchSchemasIterable.this.client.searchSchemas(SearchSchemasIterable.this.firstRequest);
            }
            return SearchSchemasIterable.this.client.searchSchemas((SearchSchemasRequest)((Object)SearchSchemasIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

