/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.schemas.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.schemas.SchemasClient;
import software.amazon.awssdk.services.schemas.model.DiscovererSummary;
import software.amazon.awssdk.services.schemas.model.ListDiscoverersRequest;
import software.amazon.awssdk.services.schemas.model.ListDiscoverersResponse;

public class ListDiscoverersIterable
implements SdkIterable<ListDiscoverersResponse> {
    private final SchemasClient client;
    private final ListDiscoverersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDiscoverersIterable(SchemasClient client, ListDiscoverersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDiscoverersResponseFetcher();
    }

    public Iterator<ListDiscoverersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DiscovererSummary> discoverers() {
        Function<ListDiscoverersResponse, Iterator> getIterator = response -> {
            if (response != null && response.discoverers() != null) {
                return response.discoverers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDiscoverersResponseFetcher
    implements SyncPageFetcher<ListDiscoverersResponse> {
        private ListDiscoverersResponseFetcher() {
        }

        public boolean hasNextPage(ListDiscoverersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDiscoverersResponse nextPage(ListDiscoverersResponse previousPage) {
            if (previousPage == null) {
                return ListDiscoverersIterable.this.client.listDiscoverers(ListDiscoverersIterable.this.firstRequest);
            }
            return ListDiscoverersIterable.this.client.listDiscoverers((ListDiscoverersRequest)((Object)ListDiscoverersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

