/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.schemas.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of schema details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SchemaSummary implements SdkPojo, Serializable, ToCopyableBuilder<SchemaSummary.Builder, SchemaSummary> {
    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModified")
            .getter(getter(SchemaSummary::lastModified))
            .setter(setter(Builder::lastModified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModified").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> SCHEMA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaArn").getter(getter(SchemaSummary::schemaArn)).setter(setter(Builder::schemaArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaArn").build()).build();

    private static final SdkField<String> SCHEMA_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaName").getter(getter(SchemaSummary::schemaName)).setter(setter(Builder::schemaName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaName").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(SchemaSummary::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Long> VERSION_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("VersionCount").getter(getter(SchemaSummary::versionCount)).setter(setter(Builder::versionCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAST_MODIFIED_FIELD,
            SCHEMA_ARN_FIELD, SCHEMA_NAME_FIELD, TAGS_FIELD, VERSION_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant lastModified;

    private final String schemaArn;

    private final String schemaName;

    private final Map<String, String> tags;

    private final Long versionCount;

    private SchemaSummary(BuilderImpl builder) {
        this.lastModified = builder.lastModified;
        this.schemaArn = builder.schemaArn;
        this.schemaName = builder.schemaName;
        this.tags = builder.tags;
        this.versionCount = builder.versionCount;
    }

    /**
     * <p>
     * The date and time that schema was modified.
     * </p>
     * 
     * @return The date and time that schema was modified.
     */
    public final Instant lastModified() {
        return lastModified;
    }

    /**
     * <p>
     * The ARN of the schema.
     * </p>
     * 
     * @return The ARN of the schema.
     */
    public final String schemaArn() {
        return schemaArn;
    }

    /**
     * <p>
     * The name of the schema.
     * </p>
     * 
     * @return The name of the schema.
     */
    public final String schemaName() {
        return schemaName;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags associated with the schema.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Tags associated with the schema.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The number of versions available for the schema.
     * </p>
     * 
     * @return The number of versions available for the schema.
     */
    public final Long versionCount() {
        return versionCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(schemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(schemaName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(versionCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaSummary)) {
            return false;
        }
        SchemaSummary other = (SchemaSummary) obj;
        return Objects.equals(lastModified(), other.lastModified()) && Objects.equals(schemaArn(), other.schemaArn())
                && Objects.equals(schemaName(), other.schemaName()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(versionCount(), other.versionCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SchemaSummary").add("LastModified", lastModified()).add("SchemaArn", schemaArn())
                .add("SchemaName", schemaName()).add("Tags", hasTags() ? tags() : null).add("VersionCount", versionCount())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LastModified":
            return Optional.ofNullable(clazz.cast(lastModified()));
        case "SchemaArn":
            return Optional.ofNullable(clazz.cast(schemaArn()));
        case "SchemaName":
            return Optional.ofNullable(clazz.cast(schemaName()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "VersionCount":
            return Optional.ofNullable(clazz.cast(versionCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SchemaSummary, T> g) {
        return obj -> g.apply((SchemaSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SchemaSummary> {
        /**
         * <p>
         * The date and time that schema was modified.
         * </p>
         * 
         * @param lastModified
         *        The date and time that schema was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModified(Instant lastModified);

        /**
         * <p>
         * The ARN of the schema.
         * </p>
         * 
         * @param schemaArn
         *        The ARN of the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaArn(String schemaArn);

        /**
         * <p>
         * The name of the schema.
         * </p>
         * 
         * @param schemaName
         *        The name of the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaName(String schemaName);

        /**
         * <p>
         * Tags associated with the schema.
         * </p>
         * 
         * @param tags
         *        Tags associated with the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The number of versions available for the schema.
         * </p>
         * 
         * @param versionCount
         *        The number of versions available for the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionCount(Long versionCount);
    }

    static final class BuilderImpl implements Builder {
        private Instant lastModified;

        private String schemaArn;

        private String schemaName;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Long versionCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SchemaSummary model) {
            lastModified(model.lastModified);
            schemaArn(model.schemaArn);
            schemaName(model.schemaName);
            tags(model.tags);
            versionCount(model.versionCount);
        }

        public final Instant getLastModified() {
            return lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        public final String getSchemaArn() {
            return schemaArn;
        }

        @Override
        public final Builder schemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
            return this;
        }

        public final void setSchemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
        }

        public final String getSchemaName() {
            return schemaName;
        }

        @Override
        public final Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public final void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        public final Long getVersionCount() {
            return versionCount;
        }

        @Override
        public final Builder versionCount(Long versionCount) {
            this.versionCount = versionCount;
            return this;
        }

        public final void setVersionCount(Long versionCount) {
            this.versionCount = versionCount;
        }

        @Override
        public SchemaSummary build() {
            return new SchemaSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
