/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.schemas.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopDiscovererResponse extends SchemasResponse implements
        ToCopyableBuilder<StopDiscovererResponse.Builder, StopDiscovererResponse> {
    private static final SdkField<String> DISCOVERER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StopDiscovererResponse::discovererId)).setter(setter(Builder::discovererId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiscovererId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StopDiscovererResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISCOVERER_ID_FIELD,
            STATE_FIELD));

    private final String discovererId;

    private final String state;

    private StopDiscovererResponse(BuilderImpl builder) {
        super(builder);
        this.discovererId = builder.discovererId;
        this.state = builder.state;
    }

    /**
     * <p>
     * The ID of the discoverer.
     * </p>
     * 
     * @return The ID of the discoverer.
     */
    public String discovererId() {
        return discovererId;
    }

    /**
     * <p>
     * The state of the discoverer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link DiscovererState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the discoverer.
     * @see DiscovererState
     */
    public DiscovererState state() {
        return DiscovererState.fromValue(state);
    }

    /**
     * <p>
     * The state of the discoverer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link DiscovererState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the discoverer.
     * @see DiscovererState
     */
    public String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(discovererId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopDiscovererResponse)) {
            return false;
        }
        StopDiscovererResponse other = (StopDiscovererResponse) obj;
        return Objects.equals(discovererId(), other.discovererId()) && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StopDiscovererResponse").add("DiscovererId", discovererId()).add("State", stateAsString())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DiscovererId":
            return Optional.ofNullable(clazz.cast(discovererId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StopDiscovererResponse, T> g) {
        return obj -> g.apply((StopDiscovererResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SchemasResponse.Builder, SdkPojo, CopyableBuilder<Builder, StopDiscovererResponse> {
        /**
         * <p>
         * The ID of the discoverer.
         * </p>
         * 
         * @param discovererId
         *        The ID of the discoverer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder discovererId(String discovererId);

        /**
         * <p>
         * The state of the discoverer.
         * </p>
         * 
         * @param state
         *        The state of the discoverer.
         * @see DiscovererState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiscovererState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the discoverer.
         * </p>
         * 
         * @param state
         *        The state of the discoverer.
         * @see DiscovererState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiscovererState
         */
        Builder state(DiscovererState state);
    }

    static final class BuilderImpl extends SchemasResponse.BuilderImpl implements Builder {
        private String discovererId;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(StopDiscovererResponse model) {
            super(model);
            discovererId(model.discovererId);
            state(model.state);
        }

        public final String getDiscovererId() {
            return discovererId;
        }

        @Override
        public final Builder discovererId(String discovererId) {
            this.discovererId = discovererId;
            return this;
        }

        public final void setDiscovererId(String discovererId) {
            this.discovererId = discovererId;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(DiscovererState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public StopDiscovererResponse build() {
            return new StopDiscovererResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
