/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.schemas.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class LockServiceLinkedRoleResponse extends SchemasResponse implements
        ToCopyableBuilder<LockServiceLinkedRoleResponse.Builder, LockServiceLinkedRoleResponse> {
    private static final SdkField<Boolean> CAN_BE_DELETED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(LockServiceLinkedRoleResponse::canBeDeleted)).setter(setter(Builder::canBeDeleted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CanBeDeleted").build()).build();

    private static final SdkField<String> REASON_OF_FAILURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LockServiceLinkedRoleResponse::reasonOfFailure)).setter(setter(Builder::reasonOfFailure))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReasonOfFailure").build()).build();

    private static final SdkField<List<DiscovererSummary>> RELATED_RESOURCES_FIELD = SdkField
            .<List<DiscovererSummary>> builder(MarshallingType.LIST)
            .getter(getter(LockServiceLinkedRoleResponse::relatedResources))
            .setter(setter(Builder::relatedResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DiscovererSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(DiscovererSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAN_BE_DELETED_FIELD,
            REASON_OF_FAILURE_FIELD, RELATED_RESOURCES_FIELD));

    private final Boolean canBeDeleted;

    private final String reasonOfFailure;

    private final List<DiscovererSummary> relatedResources;

    private LockServiceLinkedRoleResponse(BuilderImpl builder) {
        super(builder);
        this.canBeDeleted = builder.canBeDeleted;
        this.reasonOfFailure = builder.reasonOfFailure;
        this.relatedResources = builder.relatedResources;
    }

    /**
     * Returns the value of the CanBeDeleted property for this object.
     * 
     * @return The value of the CanBeDeleted property for this object.
     */
    public Boolean canBeDeleted() {
        return canBeDeleted;
    }

    /**
     * Returns the value of the ReasonOfFailure property for this object.
     * 
     * @return The value of the ReasonOfFailure property for this object.
     */
    public String reasonOfFailure() {
        return reasonOfFailure;
    }

    /**
     * Returns true if the RelatedResources property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasRelatedResources() {
        return relatedResources != null && !(relatedResources instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the RelatedResources property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRelatedResources()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the RelatedResources property for this object.
     */
    public List<DiscovererSummary> relatedResources() {
        return relatedResources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(canBeDeleted());
        hashCode = 31 * hashCode + Objects.hashCode(reasonOfFailure());
        hashCode = 31 * hashCode + Objects.hashCode(relatedResources());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LockServiceLinkedRoleResponse)) {
            return false;
        }
        LockServiceLinkedRoleResponse other = (LockServiceLinkedRoleResponse) obj;
        return Objects.equals(canBeDeleted(), other.canBeDeleted()) && Objects.equals(reasonOfFailure(), other.reasonOfFailure())
                && Objects.equals(relatedResources(), other.relatedResources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LockServiceLinkedRoleResponse").add("CanBeDeleted", canBeDeleted())
                .add("ReasonOfFailure", reasonOfFailure()).add("RelatedResources", relatedResources()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CanBeDeleted":
            return Optional.ofNullable(clazz.cast(canBeDeleted()));
        case "ReasonOfFailure":
            return Optional.ofNullable(clazz.cast(reasonOfFailure()));
        case "RelatedResources":
            return Optional.ofNullable(clazz.cast(relatedResources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LockServiceLinkedRoleResponse, T> g) {
        return obj -> g.apply((LockServiceLinkedRoleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SchemasResponse.Builder, SdkPojo, CopyableBuilder<Builder, LockServiceLinkedRoleResponse> {
        /**
         * Sets the value of the CanBeDeleted property for this object.
         *
         * @param canBeDeleted
         *        The new value for the CanBeDeleted property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canBeDeleted(Boolean canBeDeleted);

        /**
         * Sets the value of the ReasonOfFailure property for this object.
         *
         * @param reasonOfFailure
         *        The new value for the ReasonOfFailure property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasonOfFailure(String reasonOfFailure);

        /**
         * Sets the value of the RelatedResources property for this object.
         *
         * @param relatedResources
         *        The new value for the RelatedResources property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedResources(Collection<DiscovererSummary> relatedResources);

        /**
         * Sets the value of the RelatedResources property for this object.
         *
         * @param relatedResources
         *        The new value for the RelatedResources property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedResources(DiscovererSummary... relatedResources);

        /**
         * Sets the value of the RelatedResources property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<DiscovererSummary>.Builder} avoiding the
         * need to create one manually via {@link List<DiscovererSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DiscovererSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #relatedResources(List<DiscovererSummary>)}.
         * 
         * @param relatedResources
         *        a consumer that will call methods on {@link List<DiscovererSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relatedResources(List<DiscovererSummary>)
         */
        Builder relatedResources(Consumer<DiscovererSummary.Builder>... relatedResources);
    }

    static final class BuilderImpl extends SchemasResponse.BuilderImpl implements Builder {
        private Boolean canBeDeleted;

        private String reasonOfFailure;

        private List<DiscovererSummary> relatedResources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LockServiceLinkedRoleResponse model) {
            super(model);
            canBeDeleted(model.canBeDeleted);
            reasonOfFailure(model.reasonOfFailure);
            relatedResources(model.relatedResources);
        }

        public final Boolean getCanBeDeleted() {
            return canBeDeleted;
        }

        @Override
        public final Builder canBeDeleted(Boolean canBeDeleted) {
            this.canBeDeleted = canBeDeleted;
            return this;
        }

        public final void setCanBeDeleted(Boolean canBeDeleted) {
            this.canBeDeleted = canBeDeleted;
        }

        public final String getReasonOfFailure() {
            return reasonOfFailure;
        }

        @Override
        public final Builder reasonOfFailure(String reasonOfFailure) {
            this.reasonOfFailure = reasonOfFailure;
            return this;
        }

        public final void setReasonOfFailure(String reasonOfFailure) {
            this.reasonOfFailure = reasonOfFailure;
        }

        public final Collection<DiscovererSummary.Builder> getRelatedResources() {
            return relatedResources != null ? relatedResources.stream().map(DiscovererSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder relatedResources(Collection<DiscovererSummary> relatedResources) {
            this.relatedResources = ___listOfDiscovererSummaryCopier.copy(relatedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedResources(DiscovererSummary... relatedResources) {
            relatedResources(Arrays.asList(relatedResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedResources(Consumer<DiscovererSummary.Builder>... relatedResources) {
            relatedResources(Stream.of(relatedResources).map(c -> DiscovererSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRelatedResources(Collection<DiscovererSummary.BuilderImpl> relatedResources) {
            this.relatedResources = ___listOfDiscovererSummaryCopier.copyFromBuilder(relatedResources);
        }

        @Override
        public LockServiceLinkedRoleResponse build() {
            return new LockServiceLinkedRoleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
