/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.schemas.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSchemaVersionsResponse extends SchemasResponse implements
        ToCopyableBuilder<ListSchemaVersionsResponse.Builder, ListSchemaVersionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListSchemaVersionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<SchemaVersionSummary>> SCHEMA_VERSIONS_FIELD = SdkField
            .<List<SchemaVersionSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListSchemaVersionsResponse::schemaVersions))
            .setter(setter(Builder::schemaVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SchemaVersionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(SchemaVersionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            SCHEMA_VERSIONS_FIELD));

    private final String nextToken;

    private final List<SchemaVersionSummary> schemaVersions;

    private ListSchemaVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.schemaVersions = builder.schemaVersions;
    }

    /**
     * <p>
     * The token that specifies the next page of results to return. To request the first page, leave NextToken empty.
     * The token will expire in 24 hours, and cannot be shared with other accounts.
     * </p>
     * 
     * @return The token that specifies the next page of results to return. To request the first page, leave NextToken
     *         empty. The token will expire in 24 hours, and cannot be shared with other accounts.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the SchemaVersions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSchemaVersions() {
        return schemaVersions != null && !(schemaVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of schema version summaries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSchemaVersions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of schema version summaries.
     */
    public List<SchemaVersionSummary> schemaVersions() {
        return schemaVersions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(schemaVersions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSchemaVersionsResponse)) {
            return false;
        }
        ListSchemaVersionsResponse other = (ListSchemaVersionsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(schemaVersions(), other.schemaVersions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListSchemaVersionsResponse").add("NextToken", nextToken())
                .add("SchemaVersions", schemaVersions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "SchemaVersions":
            return Optional.ofNullable(clazz.cast(schemaVersions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSchemaVersionsResponse, T> g) {
        return obj -> g.apply((ListSchemaVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SchemasResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListSchemaVersionsResponse> {
        /**
         * <p>
         * The token that specifies the next page of results to return. To request the first page, leave NextToken
         * empty. The token will expire in 24 hours, and cannot be shared with other accounts.
         * </p>
         * 
         * @param nextToken
         *        The token that specifies the next page of results to return. To request the first page, leave
         *        NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of schema version summaries.
         * </p>
         * 
         * @param schemaVersions
         *        An array of schema version summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaVersions(Collection<SchemaVersionSummary> schemaVersions);

        /**
         * <p>
         * An array of schema version summaries.
         * </p>
         * 
         * @param schemaVersions
         *        An array of schema version summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaVersions(SchemaVersionSummary... schemaVersions);

        /**
         * <p>
         * An array of schema version summaries.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SchemaVersionSummary>.Builder} avoiding the
         * need to create one manually via {@link List<SchemaVersionSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SchemaVersionSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #schemaVersions(List<SchemaVersionSummary>)}.
         * 
         * @param schemaVersions
         *        a consumer that will call methods on {@link List<SchemaVersionSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schemaVersions(List<SchemaVersionSummary>)
         */
        Builder schemaVersions(Consumer<SchemaVersionSummary.Builder>... schemaVersions);
    }

    static final class BuilderImpl extends SchemasResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<SchemaVersionSummary> schemaVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSchemaVersionsResponse model) {
            super(model);
            nextToken(model.nextToken);
            schemaVersions(model.schemaVersions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<SchemaVersionSummary.Builder> getSchemaVersions() {
            return schemaVersions != null ? schemaVersions.stream().map(SchemaVersionSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder schemaVersions(Collection<SchemaVersionSummary> schemaVersions) {
            this.schemaVersions = ___listOfSchemaVersionSummaryCopier.copy(schemaVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaVersions(SchemaVersionSummary... schemaVersions) {
            schemaVersions(Arrays.asList(schemaVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaVersions(Consumer<SchemaVersionSummary.Builder>... schemaVersions) {
            schemaVersions(Stream.of(schemaVersions).map(c -> SchemaVersionSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSchemaVersions(Collection<SchemaVersionSummary.BuilderImpl> schemaVersions) {
            this.schemaVersions = ___listOfSchemaVersionSummaryCopier.copyFromBuilder(schemaVersions);
        }

        @Override
        public ListSchemaVersionsResponse build() {
            return new ListSchemaVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
