/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.scheduler.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateScheduleResponse extends SchedulerResponse implements
        ToCopyableBuilder<CreateScheduleResponse.Builder, CreateScheduleResponse> {
    private static final SdkField<String> SCHEDULE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScheduleArn").getter(getter(CreateScheduleResponse::scheduleArn)).setter(setter(Builder::scheduleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String scheduleArn;

    private CreateScheduleResponse(BuilderImpl builder) {
        super(builder);
        this.scheduleArn = builder.scheduleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the schedule.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the schedule.
     */
    public final String scheduleArn() {
        return scheduleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scheduleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateScheduleResponse)) {
            return false;
        }
        CreateScheduleResponse other = (CreateScheduleResponse) obj;
        return Objects.equals(scheduleArn(), other.scheduleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateScheduleResponse").add("ScheduleArn", scheduleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScheduleArn":
            return Optional.ofNullable(clazz.cast(scheduleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ScheduleArn", SCHEDULE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateScheduleResponse, T> g) {
        return obj -> g.apply((CreateScheduleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SchedulerResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateScheduleResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the schedule.
         * </p>
         * 
         * @param scheduleArn
         *        The Amazon Resource Name (ARN) of the schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleArn(String scheduleArn);
    }

    static final class BuilderImpl extends SchedulerResponse.BuilderImpl implements Builder {
        private String scheduleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateScheduleResponse model) {
            super(model);
            scheduleArn(model.scheduleArn);
        }

        public final String getScheduleArn() {
            return scheduleArn;
        }

        public final void setScheduleArn(String scheduleArn) {
            this.scheduleArn = scheduleArn;
        }

        @Override
        public final Builder scheduleArn(String scheduleArn) {
            this.scheduleArn = scheduleArn;
            return this;
        }

        @Override
        public CreateScheduleResponse build() {
            return new CreateScheduleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
