/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.scheduler.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.scheduler.model.DeadLetterConfig;
import software.amazon.awssdk.services.scheduler.model.EcsParameters;
import software.amazon.awssdk.services.scheduler.model.EventBridgeParameters;
import software.amazon.awssdk.services.scheduler.model.KinesisParameters;
import software.amazon.awssdk.services.scheduler.model.RetryPolicy;
import software.amazon.awssdk.services.scheduler.model.SageMakerPipelineParameters;
import software.amazon.awssdk.services.scheduler.model.SqsParameters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Target
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Target> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(Target.getter(Target::arn)).setter(Target.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<DeadLetterConfig> DEAD_LETTER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeadLetterConfig").getter(Target.getter(Target::deadLetterConfig)).setter(Target.setter(Builder::deadLetterConfig)).constructor(DeadLetterConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeadLetterConfig").build()}).build();
    private static final SdkField<EcsParameters> ECS_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EcsParameters").getter(Target.getter(Target::ecsParameters)).setter(Target.setter(Builder::ecsParameters)).constructor(EcsParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EcsParameters").build()}).build();
    private static final SdkField<EventBridgeParameters> EVENT_BRIDGE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EventBridgeParameters").getter(Target.getter(Target::eventBridgeParameters)).setter(Target.setter(Builder::eventBridgeParameters)).constructor(EventBridgeParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBridgeParameters").build()}).build();
    private static final SdkField<String> INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Input").getter(Target.getter(Target::input)).setter(Target.setter(Builder::input)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Input").build()}).build();
    private static final SdkField<KinesisParameters> KINESIS_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KinesisParameters").getter(Target.getter(Target::kinesisParameters)).setter(Target.setter(Builder::kinesisParameters)).constructor(KinesisParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisParameters").build()}).build();
    private static final SdkField<RetryPolicy> RETRY_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RetryPolicy").getter(Target.getter(Target::retryPolicy)).setter(Target.setter(Builder::retryPolicy)).constructor(RetryPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryPolicy").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(Target.getter(Target::roleArn)).setter(Target.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<SageMakerPipelineParameters> SAGE_MAKER_PIPELINE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SageMakerPipelineParameters").getter(Target.getter(Target::sageMakerPipelineParameters)).setter(Target.setter(Builder::sageMakerPipelineParameters)).constructor(SageMakerPipelineParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SageMakerPipelineParameters").build()}).build();
    private static final SdkField<SqsParameters> SQS_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SqsParameters").getter(Target.getter(Target::sqsParameters)).setter(Target.setter(Builder::sqsParameters)).constructor(SqsParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqsParameters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, DEAD_LETTER_CONFIG_FIELD, ECS_PARAMETERS_FIELD, EVENT_BRIDGE_PARAMETERS_FIELD, INPUT_FIELD, KINESIS_PARAMETERS_FIELD, RETRY_POLICY_FIELD, ROLE_ARN_FIELD, SAGE_MAKER_PIPELINE_PARAMETERS_FIELD, SQS_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Arn", ARN_FIELD);
            this.put("DeadLetterConfig", DEAD_LETTER_CONFIG_FIELD);
            this.put("EcsParameters", ECS_PARAMETERS_FIELD);
            this.put("EventBridgeParameters", EVENT_BRIDGE_PARAMETERS_FIELD);
            this.put("Input", INPUT_FIELD);
            this.put("KinesisParameters", KINESIS_PARAMETERS_FIELD);
            this.put("RetryPolicy", RETRY_POLICY_FIELD);
            this.put("RoleArn", ROLE_ARN_FIELD);
            this.put("SageMakerPipelineParameters", SAGE_MAKER_PIPELINE_PARAMETERS_FIELD);
            this.put("SqsParameters", SQS_PARAMETERS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final DeadLetterConfig deadLetterConfig;
    private final EcsParameters ecsParameters;
    private final EventBridgeParameters eventBridgeParameters;
    private final String input;
    private final KinesisParameters kinesisParameters;
    private final RetryPolicy retryPolicy;
    private final String roleArn;
    private final SageMakerPipelineParameters sageMakerPipelineParameters;
    private final SqsParameters sqsParameters;

    private Target(BuilderImpl builder) {
        this.arn = builder.arn;
        this.deadLetterConfig = builder.deadLetterConfig;
        this.ecsParameters = builder.ecsParameters;
        this.eventBridgeParameters = builder.eventBridgeParameters;
        this.input = builder.input;
        this.kinesisParameters = builder.kinesisParameters;
        this.retryPolicy = builder.retryPolicy;
        this.roleArn = builder.roleArn;
        this.sageMakerPipelineParameters = builder.sageMakerPipelineParameters;
        this.sqsParameters = builder.sqsParameters;
    }

    public final String arn() {
        return this.arn;
    }

    public final DeadLetterConfig deadLetterConfig() {
        return this.deadLetterConfig;
    }

    public final EcsParameters ecsParameters() {
        return this.ecsParameters;
    }

    public final EventBridgeParameters eventBridgeParameters() {
        return this.eventBridgeParameters;
    }

    public final String input() {
        return this.input;
    }

    public final KinesisParameters kinesisParameters() {
        return this.kinesisParameters;
    }

    public final RetryPolicy retryPolicy() {
        return this.retryPolicy;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final SageMakerPipelineParameters sageMakerPipelineParameters() {
        return this.sageMakerPipelineParameters;
    }

    public final SqsParameters sqsParameters() {
        return this.sqsParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.deadLetterConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.ecsParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventBridgeParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.input());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sageMakerPipelineParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.sqsParameters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Target)) {
            return false;
        }
        Target other = (Target)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.deadLetterConfig(), other.deadLetterConfig()) && Objects.equals(this.ecsParameters(), other.ecsParameters()) && Objects.equals(this.eventBridgeParameters(), other.eventBridgeParameters()) && Objects.equals(this.input(), other.input()) && Objects.equals(this.kinesisParameters(), other.kinesisParameters()) && Objects.equals(this.retryPolicy(), other.retryPolicy()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.sageMakerPipelineParameters(), other.sageMakerPipelineParameters()) && Objects.equals(this.sqsParameters(), other.sqsParameters());
    }

    public final String toString() {
        return ToString.builder((String)"Target").add("Arn", (Object)this.arn()).add("DeadLetterConfig", (Object)this.deadLetterConfig()).add("EcsParameters", (Object)this.ecsParameters()).add("EventBridgeParameters", (Object)this.eventBridgeParameters()).add("Input", (Object)this.input()).add("KinesisParameters", (Object)this.kinesisParameters()).add("RetryPolicy", (Object)this.retryPolicy()).add("RoleArn", (Object)this.roleArn()).add("SageMakerPipelineParameters", (Object)this.sageMakerPipelineParameters()).add("SqsParameters", (Object)this.sqsParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "DeadLetterConfig": {
                return Optional.ofNullable(clazz.cast(this.deadLetterConfig()));
            }
            case "EcsParameters": {
                return Optional.ofNullable(clazz.cast(this.ecsParameters()));
            }
            case "EventBridgeParameters": {
                return Optional.ofNullable(clazz.cast(this.eventBridgeParameters()));
            }
            case "Input": {
                return Optional.ofNullable(clazz.cast(this.input()));
            }
            case "KinesisParameters": {
                return Optional.ofNullable(clazz.cast(this.kinesisParameters()));
            }
            case "RetryPolicy": {
                return Optional.ofNullable(clazz.cast(this.retryPolicy()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "SageMakerPipelineParameters": {
                return Optional.ofNullable(clazz.cast(this.sageMakerPipelineParameters()));
            }
            case "SqsParameters": {
                return Optional.ofNullable(clazz.cast(this.sqsParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Target, T> g) {
        return obj -> g.apply((Target)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private DeadLetterConfig deadLetterConfig;
        private EcsParameters ecsParameters;
        private EventBridgeParameters eventBridgeParameters;
        private String input;
        private KinesisParameters kinesisParameters;
        private RetryPolicy retryPolicy;
        private String roleArn;
        private SageMakerPipelineParameters sageMakerPipelineParameters;
        private SqsParameters sqsParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(Target model) {
            this.arn(model.arn);
            this.deadLetterConfig(model.deadLetterConfig);
            this.ecsParameters(model.ecsParameters);
            this.eventBridgeParameters(model.eventBridgeParameters);
            this.input(model.input);
            this.kinesisParameters(model.kinesisParameters);
            this.retryPolicy(model.retryPolicy);
            this.roleArn(model.roleArn);
            this.sageMakerPipelineParameters(model.sageMakerPipelineParameters);
            this.sqsParameters(model.sqsParameters);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final DeadLetterConfig.Builder getDeadLetterConfig() {
            return this.deadLetterConfig != null ? this.deadLetterConfig.toBuilder() : null;
        }

        public final void setDeadLetterConfig(DeadLetterConfig.BuilderImpl deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig != null ? deadLetterConfig.build() : null;
        }

        @Override
        public final Builder deadLetterConfig(DeadLetterConfig deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig;
            return this;
        }

        public final EcsParameters.Builder getEcsParameters() {
            return this.ecsParameters != null ? this.ecsParameters.toBuilder() : null;
        }

        public final void setEcsParameters(EcsParameters.BuilderImpl ecsParameters) {
            this.ecsParameters = ecsParameters != null ? ecsParameters.build() : null;
        }

        @Override
        public final Builder ecsParameters(EcsParameters ecsParameters) {
            this.ecsParameters = ecsParameters;
            return this;
        }

        public final EventBridgeParameters.Builder getEventBridgeParameters() {
            return this.eventBridgeParameters != null ? this.eventBridgeParameters.toBuilder() : null;
        }

        public final void setEventBridgeParameters(EventBridgeParameters.BuilderImpl eventBridgeParameters) {
            this.eventBridgeParameters = eventBridgeParameters != null ? eventBridgeParameters.build() : null;
        }

        @Override
        public final Builder eventBridgeParameters(EventBridgeParameters eventBridgeParameters) {
            this.eventBridgeParameters = eventBridgeParameters;
            return this;
        }

        public final String getInput() {
            return this.input;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final KinesisParameters.Builder getKinesisParameters() {
            return this.kinesisParameters != null ? this.kinesisParameters.toBuilder() : null;
        }

        public final void setKinesisParameters(KinesisParameters.BuilderImpl kinesisParameters) {
            this.kinesisParameters = kinesisParameters != null ? kinesisParameters.build() : null;
        }

        @Override
        public final Builder kinesisParameters(KinesisParameters kinesisParameters) {
            this.kinesisParameters = kinesisParameters;
            return this;
        }

        public final RetryPolicy.Builder getRetryPolicy() {
            return this.retryPolicy != null ? this.retryPolicy.toBuilder() : null;
        }

        public final void setRetryPolicy(RetryPolicy.BuilderImpl retryPolicy) {
            this.retryPolicy = retryPolicy != null ? retryPolicy.build() : null;
        }

        @Override
        public final Builder retryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final SageMakerPipelineParameters.Builder getSageMakerPipelineParameters() {
            return this.sageMakerPipelineParameters != null ? this.sageMakerPipelineParameters.toBuilder() : null;
        }

        public final void setSageMakerPipelineParameters(SageMakerPipelineParameters.BuilderImpl sageMakerPipelineParameters) {
            this.sageMakerPipelineParameters = sageMakerPipelineParameters != null ? sageMakerPipelineParameters.build() : null;
        }

        @Override
        public final Builder sageMakerPipelineParameters(SageMakerPipelineParameters sageMakerPipelineParameters) {
            this.sageMakerPipelineParameters = sageMakerPipelineParameters;
            return this;
        }

        public final SqsParameters.Builder getSqsParameters() {
            return this.sqsParameters != null ? this.sqsParameters.toBuilder() : null;
        }

        public final void setSqsParameters(SqsParameters.BuilderImpl sqsParameters) {
            this.sqsParameters = sqsParameters != null ? sqsParameters.build() : null;
        }

        @Override
        public final Builder sqsParameters(SqsParameters sqsParameters) {
            this.sqsParameters = sqsParameters;
            return this;
        }

        public Target build() {
            return new Target(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Target> {
        public Builder arn(String var1);

        public Builder deadLetterConfig(DeadLetterConfig var1);

        default public Builder deadLetterConfig(Consumer<DeadLetterConfig.Builder> deadLetterConfig) {
            return this.deadLetterConfig((DeadLetterConfig)((DeadLetterConfig.Builder)DeadLetterConfig.builder().applyMutation(deadLetterConfig)).build());
        }

        public Builder ecsParameters(EcsParameters var1);

        default public Builder ecsParameters(Consumer<EcsParameters.Builder> ecsParameters) {
            return this.ecsParameters((EcsParameters)((EcsParameters.Builder)EcsParameters.builder().applyMutation(ecsParameters)).build());
        }

        public Builder eventBridgeParameters(EventBridgeParameters var1);

        default public Builder eventBridgeParameters(Consumer<EventBridgeParameters.Builder> eventBridgeParameters) {
            return this.eventBridgeParameters((EventBridgeParameters)((EventBridgeParameters.Builder)EventBridgeParameters.builder().applyMutation(eventBridgeParameters)).build());
        }

        public Builder input(String var1);

        public Builder kinesisParameters(KinesisParameters var1);

        default public Builder kinesisParameters(Consumer<KinesisParameters.Builder> kinesisParameters) {
            return this.kinesisParameters((KinesisParameters)((KinesisParameters.Builder)KinesisParameters.builder().applyMutation(kinesisParameters)).build());
        }

        public Builder retryPolicy(RetryPolicy var1);

        default public Builder retryPolicy(Consumer<RetryPolicy.Builder> retryPolicy) {
            return this.retryPolicy((RetryPolicy)((RetryPolicy.Builder)RetryPolicy.builder().applyMutation(retryPolicy)).build());
        }

        public Builder roleArn(String var1);

        public Builder sageMakerPipelineParameters(SageMakerPipelineParameters var1);

        default public Builder sageMakerPipelineParameters(Consumer<SageMakerPipelineParameters.Builder> sageMakerPipelineParameters) {
            return this.sageMakerPipelineParameters((SageMakerPipelineParameters)((SageMakerPipelineParameters.Builder)SageMakerPipelineParameters.builder().applyMutation(sageMakerPipelineParameters)).build());
        }

        public Builder sqsParameters(SqsParameters var1);

        default public Builder sqsParameters(Consumer<SqsParameters.Builder> sqsParameters) {
            return this.sqsParameters((SqsParameters)((SqsParameters.Builder)SqsParameters.builder().applyMutation(sqsParameters)).build());
        }
    }
}

