/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.scheduler;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.scheduler.DefaultSchedulerClientBuilder;
import software.amazon.awssdk.services.scheduler.SchedulerClientBuilder;
import software.amazon.awssdk.services.scheduler.SchedulerServiceClientConfiguration;
import software.amazon.awssdk.services.scheduler.model.ConflictException;
import software.amazon.awssdk.services.scheduler.model.CreateScheduleGroupRequest;
import software.amazon.awssdk.services.scheduler.model.CreateScheduleGroupResponse;
import software.amazon.awssdk.services.scheduler.model.CreateScheduleRequest;
import software.amazon.awssdk.services.scheduler.model.CreateScheduleResponse;
import software.amazon.awssdk.services.scheduler.model.DeleteScheduleGroupRequest;
import software.amazon.awssdk.services.scheduler.model.DeleteScheduleGroupResponse;
import software.amazon.awssdk.services.scheduler.model.DeleteScheduleRequest;
import software.amazon.awssdk.services.scheduler.model.DeleteScheduleResponse;
import software.amazon.awssdk.services.scheduler.model.GetScheduleGroupRequest;
import software.amazon.awssdk.services.scheduler.model.GetScheduleGroupResponse;
import software.amazon.awssdk.services.scheduler.model.GetScheduleRequest;
import software.amazon.awssdk.services.scheduler.model.GetScheduleResponse;
import software.amazon.awssdk.services.scheduler.model.InternalServerException;
import software.amazon.awssdk.services.scheduler.model.ListScheduleGroupsRequest;
import software.amazon.awssdk.services.scheduler.model.ListScheduleGroupsResponse;
import software.amazon.awssdk.services.scheduler.model.ListSchedulesRequest;
import software.amazon.awssdk.services.scheduler.model.ListSchedulesResponse;
import software.amazon.awssdk.services.scheduler.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.scheduler.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.scheduler.model.ResourceNotFoundException;
import software.amazon.awssdk.services.scheduler.model.SchedulerException;
import software.amazon.awssdk.services.scheduler.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.scheduler.model.TagResourceRequest;
import software.amazon.awssdk.services.scheduler.model.TagResourceResponse;
import software.amazon.awssdk.services.scheduler.model.ThrottlingException;
import software.amazon.awssdk.services.scheduler.model.UntagResourceRequest;
import software.amazon.awssdk.services.scheduler.model.UntagResourceResponse;
import software.amazon.awssdk.services.scheduler.model.UpdateScheduleRequest;
import software.amazon.awssdk.services.scheduler.model.UpdateScheduleResponse;
import software.amazon.awssdk.services.scheduler.model.ValidationException;
import software.amazon.awssdk.services.scheduler.paginators.ListScheduleGroupsIterable;
import software.amazon.awssdk.services.scheduler.paginators.ListSchedulesIterable;

@SdkPublicApi
@ThreadSafe
public interface SchedulerClient
extends AwsClient {
    public static final String SERVICE_NAME = "scheduler";
    public static final String SERVICE_METADATA_ID = "scheduler";

    default public CreateScheduleResponse createSchedule(CreateScheduleRequest createScheduleRequest) throws ServiceQuotaExceededException, ValidationException, InternalServerException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, SchedulerException {
        throw new UnsupportedOperationException();
    }

    default public CreateScheduleResponse createSchedule(Consumer<CreateScheduleRequest.Builder> createScheduleRequest) throws ServiceQuotaExceededException, ValidationException, InternalServerException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, SchedulerException {
        return this.createSchedule((CreateScheduleRequest)((Object)((CreateScheduleRequest.Builder)CreateScheduleRequest.builder().applyMutation(createScheduleRequest)).build()));
    }

    default public CreateScheduleGroupResponse createScheduleGroup(CreateScheduleGroupRequest createScheduleGroupRequest) throws ServiceQuotaExceededException, ValidationException, InternalServerException, ConflictException, ThrottlingException, AwsServiceException, SdkClientException, SchedulerException {
        throw new UnsupportedOperationException();
    }

    default public CreateScheduleGroupResponse createScheduleGroup(Consumer<CreateScheduleGroupRequest.Builder> createScheduleGroupRequest) throws ServiceQuotaExceededException, ValidationException, InternalServerException, ConflictException, ThrottlingException, AwsServiceException, SdkClientException, SchedulerException {
        return this.createScheduleGroup((CreateScheduleGroupRequest)((Object)((CreateScheduleGroupRequest.Builder)CreateScheduleGroupRequest.builder().applyMutation(createScheduleGroupRequest)).build()));
    }

    default public DeleteScheduleResponse deleteSchedule(DeleteScheduleRequest deleteScheduleRequest) throws ValidationException, InternalServerException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, SchedulerException {
        throw new UnsupportedOperationException();
    }

    default public DeleteScheduleResponse deleteSchedule(Consumer<DeleteScheduleRequest.Builder> deleteScheduleRequest) throws ValidationException, InternalServerException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, SchedulerException {
        return this.deleteSchedule((DeleteScheduleRequest)((Object)((DeleteScheduleRequest.Builder)DeleteScheduleRequest.builder().applyMutation(deleteScheduleRequest)).build()));
    }

    default public DeleteScheduleGroupResponse deleteScheduleGroup(DeleteScheduleGroupRequest deleteScheduleGroupRequest) throws ValidationException, InternalServerException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, SchedulerException {
        throw new UnsupportedOperationException();
    }

    default public DeleteScheduleGroupResponse deleteScheduleGroup(Consumer<DeleteScheduleGroupRequest.Builder> deleteScheduleGroupRequest) throws ValidationException, InternalServerException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, SchedulerException {
        return this.deleteScheduleGroup((DeleteScheduleGroupRequest)((Object)((DeleteScheduleGroupRequest.Builder)DeleteScheduleGroupRequest.builder().applyMutation(deleteScheduleGroupRequest)).build()));
    }

    default public GetScheduleResponse getSchedule(GetScheduleRequest getScheduleRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, SchedulerException {
        throw new UnsupportedOperationException();
    }

    default public GetScheduleResponse getSchedule(Consumer<GetScheduleRequest.Builder> getScheduleRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, SchedulerException {
        return this.getSchedule((GetScheduleRequest)((Object)((GetScheduleRequest.Builder)GetScheduleRequest.builder().applyMutation(getScheduleRequest)).build()));
    }

    default public GetScheduleGroupResponse getScheduleGroup(GetScheduleGroupRequest getScheduleGroupRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, SchedulerException {
        throw new UnsupportedOperationException();
    }

    default public GetScheduleGroupResponse getScheduleGroup(Consumer<GetScheduleGroupRequest.Builder> getScheduleGroupRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, SchedulerException {
        return this.getScheduleGroup((GetScheduleGroupRequest)((Object)((GetScheduleGroupRequest.Builder)GetScheduleGroupRequest.builder().applyMutation(getScheduleGroupRequest)).build()));
    }

    default public ListScheduleGroupsResponse listScheduleGroups(ListScheduleGroupsRequest listScheduleGroupsRequest) throws ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, SchedulerException {
        throw new UnsupportedOperationException();
    }

    default public ListScheduleGroupsResponse listScheduleGroups(Consumer<ListScheduleGroupsRequest.Builder> listScheduleGroupsRequest) throws ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, SchedulerException {
        return this.listScheduleGroups((ListScheduleGroupsRequest)((Object)((ListScheduleGroupsRequest.Builder)ListScheduleGroupsRequest.builder().applyMutation(listScheduleGroupsRequest)).build()));
    }

    default public ListScheduleGroupsIterable listScheduleGroupsPaginator(ListScheduleGroupsRequest listScheduleGroupsRequest) throws ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, SchedulerException {
        throw new UnsupportedOperationException();
    }

    default public ListScheduleGroupsIterable listScheduleGroupsPaginator(Consumer<ListScheduleGroupsRequest.Builder> listScheduleGroupsRequest) throws ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, SchedulerException {
        return this.listScheduleGroupsPaginator((ListScheduleGroupsRequest)((Object)((ListScheduleGroupsRequest.Builder)ListScheduleGroupsRequest.builder().applyMutation(listScheduleGroupsRequest)).build()));
    }

    default public ListSchedulesResponse listSchedules(ListSchedulesRequest listSchedulesRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, SchedulerException {
        throw new UnsupportedOperationException();
    }

    default public ListSchedulesResponse listSchedules(Consumer<ListSchedulesRequest.Builder> listSchedulesRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, SchedulerException {
        return this.listSchedules((ListSchedulesRequest)((Object)((ListSchedulesRequest.Builder)ListSchedulesRequest.builder().applyMutation(listSchedulesRequest)).build()));
    }

    default public ListSchedulesIterable listSchedulesPaginator(ListSchedulesRequest listSchedulesRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, SchedulerException {
        throw new UnsupportedOperationException();
    }

    default public ListSchedulesIterable listSchedulesPaginator(Consumer<ListSchedulesRequest.Builder> listSchedulesRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, SchedulerException {
        return this.listSchedulesPaginator((ListSchedulesRequest)((Object)((ListSchedulesRequest.Builder)ListSchedulesRequest.builder().applyMutation(listSchedulesRequest)).build()));
    }

    default public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, SchedulerException {
        throw new UnsupportedOperationException();
    }

    default public ListTagsForResourceResponse listTagsForResource(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, SchedulerException {
        return this.listTagsForResource((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException, InternalServerException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, SchedulerException {
        throw new UnsupportedOperationException();
    }

    default public TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ValidationException, InternalServerException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, SchedulerException {
        return this.tagResource((TagResourceRequest)((Object)((TagResourceRequest.Builder)TagResourceRequest.builder().applyMutation(tagResourceRequest)).build()));
    }

    default public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException, InternalServerException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, SchedulerException {
        throw new UnsupportedOperationException();
    }

    default public UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) throws ValidationException, InternalServerException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, SchedulerException {
        return this.untagResource((UntagResourceRequest)((Object)((UntagResourceRequest.Builder)UntagResourceRequest.builder().applyMutation(untagResourceRequest)).build()));
    }

    default public UpdateScheduleResponse updateSchedule(UpdateScheduleRequest updateScheduleRequest) throws ValidationException, InternalServerException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, SchedulerException {
        throw new UnsupportedOperationException();
    }

    default public UpdateScheduleResponse updateSchedule(Consumer<UpdateScheduleRequest.Builder> updateScheduleRequest) throws ValidationException, InternalServerException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, SchedulerException {
        return this.updateSchedule((UpdateScheduleRequest)((Object)((UpdateScheduleRequest.Builder)UpdateScheduleRequest.builder().applyMutation(updateScheduleRequest)).build()));
    }

    public static SchedulerClient create() {
        return (SchedulerClient)SchedulerClient.builder().build();
    }

    public static SchedulerClientBuilder builder() {
        return new DefaultSchedulerClientBuilder();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"scheduler");
    }

    public SchedulerServiceClientConfiguration serviceClientConfiguration();
}

