/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakermetrics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemakermetrics.model.RawMetricData;
import software.amazon.awssdk.services.sagemakermetrics.model.RawMetricDataListCopier;
import software.amazon.awssdk.services.sagemakermetrics.model.SageMakerMetricsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchPutMetricsRequest
extends SageMakerMetricsRequest
implements ToCopyableBuilder<Builder, BatchPutMetricsRequest> {
    private static final SdkField<String> TRIAL_COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrialComponentName").getter(BatchPutMetricsRequest.getter(BatchPutMetricsRequest::trialComponentName)).setter(BatchPutMetricsRequest.setter(Builder::trialComponentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialComponentName").build()}).build();
    private static final SdkField<List<RawMetricData>> METRIC_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricData").getter(BatchPutMetricsRequest.getter(BatchPutMetricsRequest::metricData)).setter(BatchPutMetricsRequest.setter(Builder::metricData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricData").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RawMetricData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRIAL_COMPONENT_NAME_FIELD, METRIC_DATA_FIELD));
    private final String trialComponentName;
    private final List<RawMetricData> metricData;

    private BatchPutMetricsRequest(BuilderImpl builder) {
        super(builder);
        this.trialComponentName = builder.trialComponentName;
        this.metricData = builder.metricData;
    }

    public final String trialComponentName() {
        return this.trialComponentName;
    }

    public final boolean hasMetricData() {
        return this.metricData != null && !(this.metricData instanceof SdkAutoConstructList);
    }

    public final List<RawMetricData> metricData() {
        return this.metricData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trialComponentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricData() ? this.metricData() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPutMetricsRequest)) {
            return false;
        }
        BatchPutMetricsRequest other = (BatchPutMetricsRequest)((Object)obj);
        return Objects.equals(this.trialComponentName(), other.trialComponentName()) && this.hasMetricData() == other.hasMetricData() && Objects.equals(this.metricData(), other.metricData());
    }

    public final String toString() {
        return ToString.builder((String)"BatchPutMetricsRequest").add("TrialComponentName", (Object)this.trialComponentName()).add("MetricData", this.hasMetricData() ? this.metricData() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrialComponentName": {
                return Optional.ofNullable(clazz.cast(this.trialComponentName()));
            }
            case "MetricData": {
                return Optional.ofNullable(clazz.cast(this.metricData()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchPutMetricsRequest, T> g) {
        return obj -> g.apply((BatchPutMetricsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerMetricsRequest.BuilderImpl
    implements Builder {
        private String trialComponentName;
        private List<RawMetricData> metricData = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchPutMetricsRequest model) {
            super(model);
            this.trialComponentName(model.trialComponentName);
            this.metricData(model.metricData);
        }

        public final String getTrialComponentName() {
            return this.trialComponentName;
        }

        public final void setTrialComponentName(String trialComponentName) {
            this.trialComponentName = trialComponentName;
        }

        @Override
        public final Builder trialComponentName(String trialComponentName) {
            this.trialComponentName = trialComponentName;
            return this;
        }

        public final List<RawMetricData.Builder> getMetricData() {
            List<RawMetricData.Builder> result = RawMetricDataListCopier.copyToBuilder(this.metricData);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricData(Collection<RawMetricData.BuilderImpl> metricData) {
            this.metricData = RawMetricDataListCopier.copyFromBuilder(metricData);
        }

        @Override
        public final Builder metricData(Collection<RawMetricData> metricData) {
            this.metricData = RawMetricDataListCopier.copy(metricData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricData(RawMetricData ... metricData) {
            this.metricData(Arrays.asList(metricData));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricData(Consumer<RawMetricData.Builder> ... metricData) {
            this.metricData(Stream.of(metricData).map(c -> (RawMetricData)((RawMetricData.Builder)RawMetricData.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchPutMetricsRequest build() {
            return new BatchPutMetricsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerMetricsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchPutMetricsRequest> {
        public Builder trialComponentName(String var1);

        public Builder metricData(Collection<RawMetricData> var1);

        public Builder metricData(RawMetricData ... var1);

        public Builder metricData(Consumer<RawMetricData.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

