/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemakergeospatial.model.StringListInputCopier;
import software.amazon.awssdk.services.sagemakergeospatial.model.ZonalStatistics;
import software.amazon.awssdk.services.sagemakergeospatial.model.ZonalStatisticsListInputCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ZonalStatisticsConfigInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ZonalStatisticsConfigInput> {
    private static final SdkField<List<String>> STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Statistics").getter(ZonalStatisticsConfigInput.getter(ZonalStatisticsConfigInput::statisticsAsStrings)).setter(ZonalStatisticsConfigInput.setter(Builder::statisticsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statistics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TARGET_BANDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetBands").getter(ZonalStatisticsConfigInput.getter(ZonalStatisticsConfigInput::targetBands)).setter(ZonalStatisticsConfigInput.setter(Builder::targetBands)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetBands").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ZONE_S3_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ZoneS3Path").getter(ZonalStatisticsConfigInput.getter(ZonalStatisticsConfigInput::zoneS3Path)).setter(ZonalStatisticsConfigInput.setter(Builder::zoneS3Path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZoneS3Path").build()}).build();
    private static final SdkField<String> ZONE_S3_PATH_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ZoneS3PathKmsKeyId").getter(ZonalStatisticsConfigInput.getter(ZonalStatisticsConfigInput::zoneS3PathKmsKeyId)).setter(ZonalStatisticsConfigInput.setter(Builder::zoneS3PathKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZoneS3PathKmsKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATISTICS_FIELD, TARGET_BANDS_FIELD, ZONE_S3_PATH_FIELD, ZONE_S3_PATH_KMS_KEY_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ZonalStatisticsConfigInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> statistics;
    private final List<String> targetBands;
    private final String zoneS3Path;
    private final String zoneS3PathKmsKeyId;

    private ZonalStatisticsConfigInput(BuilderImpl builder) {
        this.statistics = builder.statistics;
        this.targetBands = builder.targetBands;
        this.zoneS3Path = builder.zoneS3Path;
        this.zoneS3PathKmsKeyId = builder.zoneS3PathKmsKeyId;
    }

    public final List<ZonalStatistics> statistics() {
        return ZonalStatisticsListInputCopier.copyStringToEnum(this.statistics);
    }

    public final boolean hasStatistics() {
        return this.statistics != null && !(this.statistics instanceof SdkAutoConstructList);
    }

    public final List<String> statisticsAsStrings() {
        return this.statistics;
    }

    public final boolean hasTargetBands() {
        return this.targetBands != null && !(this.targetBands instanceof SdkAutoConstructList);
    }

    public final List<String> targetBands() {
        return this.targetBands;
    }

    public final String zoneS3Path() {
        return this.zoneS3Path;
    }

    public final String zoneS3PathKmsKeyId() {
        return this.zoneS3PathKmsKeyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatistics() ? this.statisticsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetBands() ? this.targetBands() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.zoneS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(this.zoneS3PathKmsKeyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ZonalStatisticsConfigInput)) {
            return false;
        }
        ZonalStatisticsConfigInput other = (ZonalStatisticsConfigInput)obj;
        return this.hasStatistics() == other.hasStatistics() && Objects.equals(this.statisticsAsStrings(), other.statisticsAsStrings()) && this.hasTargetBands() == other.hasTargetBands() && Objects.equals(this.targetBands(), other.targetBands()) && Objects.equals(this.zoneS3Path(), other.zoneS3Path()) && Objects.equals(this.zoneS3PathKmsKeyId(), other.zoneS3PathKmsKeyId());
    }

    public final String toString() {
        return ToString.builder((String)"ZonalStatisticsConfigInput").add("Statistics", this.hasStatistics() ? this.statisticsAsStrings() : null).add("TargetBands", this.hasTargetBands() ? this.targetBands() : null).add("ZoneS3Path", (Object)this.zoneS3Path()).add("ZoneS3PathKmsKeyId", (Object)this.zoneS3PathKmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Statistics": {
                return Optional.ofNullable(clazz.cast(this.statisticsAsStrings()));
            }
            case "TargetBands": {
                return Optional.ofNullable(clazz.cast(this.targetBands()));
            }
            case "ZoneS3Path": {
                return Optional.ofNullable(clazz.cast(this.zoneS3Path()));
            }
            case "ZoneS3PathKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.zoneS3PathKmsKeyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Statistics", STATISTICS_FIELD);
        map.put("TargetBands", TARGET_BANDS_FIELD);
        map.put("ZoneS3Path", ZONE_S3_PATH_FIELD);
        map.put("ZoneS3PathKmsKeyId", ZONE_S3_PATH_KMS_KEY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ZonalStatisticsConfigInput, T> g) {
        return obj -> g.apply((ZonalStatisticsConfigInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> statistics = DefaultSdkAutoConstructList.getInstance();
        private List<String> targetBands = DefaultSdkAutoConstructList.getInstance();
        private String zoneS3Path;
        private String zoneS3PathKmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(ZonalStatisticsConfigInput model) {
            this.statisticsWithStrings(model.statistics);
            this.targetBands(model.targetBands);
            this.zoneS3Path(model.zoneS3Path);
            this.zoneS3PathKmsKeyId(model.zoneS3PathKmsKeyId);
        }

        public final Collection<String> getStatistics() {
            if (this.statistics instanceof SdkAutoConstructList) {
                return null;
            }
            return this.statistics;
        }

        public final void setStatistics(Collection<String> statistics) {
            this.statistics = ZonalStatisticsListInputCopier.copy(statistics);
        }

        @Override
        public final Builder statisticsWithStrings(Collection<String> statistics) {
            this.statistics = ZonalStatisticsListInputCopier.copy(statistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statisticsWithStrings(String ... statistics) {
            this.statisticsWithStrings(Arrays.asList(statistics));
            return this;
        }

        @Override
        public final Builder statistics(Collection<ZonalStatistics> statistics) {
            this.statistics = ZonalStatisticsListInputCopier.copyEnumToString(statistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statistics(ZonalStatistics ... statistics) {
            this.statistics(Arrays.asList(statistics));
            return this;
        }

        public final Collection<String> getTargetBands() {
            if (this.targetBands instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetBands;
        }

        public final void setTargetBands(Collection<String> targetBands) {
            this.targetBands = StringListInputCopier.copy(targetBands);
        }

        @Override
        public final Builder targetBands(Collection<String> targetBands) {
            this.targetBands = StringListInputCopier.copy(targetBands);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetBands(String ... targetBands) {
            this.targetBands(Arrays.asList(targetBands));
            return this;
        }

        public final String getZoneS3Path() {
            return this.zoneS3Path;
        }

        public final void setZoneS3Path(String zoneS3Path) {
            this.zoneS3Path = zoneS3Path;
        }

        @Override
        public final Builder zoneS3Path(String zoneS3Path) {
            this.zoneS3Path = zoneS3Path;
            return this;
        }

        public final String getZoneS3PathKmsKeyId() {
            return this.zoneS3PathKmsKeyId;
        }

        public final void setZoneS3PathKmsKeyId(String zoneS3PathKmsKeyId) {
            this.zoneS3PathKmsKeyId = zoneS3PathKmsKeyId;
        }

        @Override
        public final Builder zoneS3PathKmsKeyId(String zoneS3PathKmsKeyId) {
            this.zoneS3PathKmsKeyId = zoneS3PathKmsKeyId;
            return this;
        }

        public ZonalStatisticsConfigInput build() {
            return new ZonalStatisticsConfigInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ZonalStatisticsConfigInput> {
        public Builder statisticsWithStrings(Collection<String> var1);

        public Builder statisticsWithStrings(String ... var1);

        public Builder statistics(Collection<ZonalStatistics> var1);

        public Builder statistics(ZonalStatistics ... var1);

        public Builder targetBands(Collection<String> var1);

        public Builder targetBands(String ... var1);

        public Builder zoneS3Path(String var1);

        public Builder zoneS3PathKmsKeyId(String var1);
    }
}

