/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemakergeospatial.model.AlgorithmNameCloudRemoval;
import software.amazon.awssdk.services.sagemakergeospatial.model.StringListInputCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CloudRemovalConfigInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CloudRemovalConfigInput> {
    private static final SdkField<String> ALGORITHM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlgorithmName").getter(CloudRemovalConfigInput.getter(CloudRemovalConfigInput::algorithmNameAsString)).setter(CloudRemovalConfigInput.setter(Builder::algorithmName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmName").build()}).build();
    private static final SdkField<String> INTERPOLATION_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InterpolationValue").getter(CloudRemovalConfigInput.getter(CloudRemovalConfigInput::interpolationValue)).setter(CloudRemovalConfigInput.setter(Builder::interpolationValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InterpolationValue").build()}).build();
    private static final SdkField<List<String>> TARGET_BANDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetBands").getter(CloudRemovalConfigInput.getter(CloudRemovalConfigInput::targetBands)).setter(CloudRemovalConfigInput.setter(Builder::targetBands)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetBands").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALGORITHM_NAME_FIELD, INTERPOLATION_VALUE_FIELD, TARGET_BANDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CloudRemovalConfigInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String algorithmName;
    private final String interpolationValue;
    private final List<String> targetBands;

    private CloudRemovalConfigInput(BuilderImpl builder) {
        this.algorithmName = builder.algorithmName;
        this.interpolationValue = builder.interpolationValue;
        this.targetBands = builder.targetBands;
    }

    public final AlgorithmNameCloudRemoval algorithmName() {
        return AlgorithmNameCloudRemoval.fromValue(this.algorithmName);
    }

    public final String algorithmNameAsString() {
        return this.algorithmName;
    }

    public final String interpolationValue() {
        return this.interpolationValue;
    }

    public final boolean hasTargetBands() {
        return this.targetBands != null && !(this.targetBands instanceof SdkAutoConstructList);
    }

    public final List<String> targetBands() {
        return this.targetBands;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.interpolationValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetBands() ? this.targetBands() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudRemovalConfigInput)) {
            return false;
        }
        CloudRemovalConfigInput other = (CloudRemovalConfigInput)obj;
        return Objects.equals(this.algorithmNameAsString(), other.algorithmNameAsString()) && Objects.equals(this.interpolationValue(), other.interpolationValue()) && this.hasTargetBands() == other.hasTargetBands() && Objects.equals(this.targetBands(), other.targetBands());
    }

    public final String toString() {
        return ToString.builder((String)"CloudRemovalConfigInput").add("AlgorithmName", (Object)this.algorithmNameAsString()).add("InterpolationValue", (Object)this.interpolationValue()).add("TargetBands", this.hasTargetBands() ? this.targetBands() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AlgorithmName": {
                return Optional.ofNullable(clazz.cast(this.algorithmNameAsString()));
            }
            case "InterpolationValue": {
                return Optional.ofNullable(clazz.cast(this.interpolationValue()));
            }
            case "TargetBands": {
                return Optional.ofNullable(clazz.cast(this.targetBands()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AlgorithmName", ALGORITHM_NAME_FIELD);
        map.put("InterpolationValue", INTERPOLATION_VALUE_FIELD);
        map.put("TargetBands", TARGET_BANDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CloudRemovalConfigInput, T> g) {
        return obj -> g.apply((CloudRemovalConfigInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String algorithmName;
        private String interpolationValue;
        private List<String> targetBands = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CloudRemovalConfigInput model) {
            this.algorithmName(model.algorithmName);
            this.interpolationValue(model.interpolationValue);
            this.targetBands(model.targetBands);
        }

        public final String getAlgorithmName() {
            return this.algorithmName;
        }

        public final void setAlgorithmName(String algorithmName) {
            this.algorithmName = algorithmName;
        }

        @Override
        public final Builder algorithmName(String algorithmName) {
            this.algorithmName = algorithmName;
            return this;
        }

        @Override
        public final Builder algorithmName(AlgorithmNameCloudRemoval algorithmName) {
            this.algorithmName(algorithmName == null ? null : algorithmName.toString());
            return this;
        }

        public final String getInterpolationValue() {
            return this.interpolationValue;
        }

        public final void setInterpolationValue(String interpolationValue) {
            this.interpolationValue = interpolationValue;
        }

        @Override
        public final Builder interpolationValue(String interpolationValue) {
            this.interpolationValue = interpolationValue;
            return this;
        }

        public final Collection<String> getTargetBands() {
            if (this.targetBands instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetBands;
        }

        public final void setTargetBands(Collection<String> targetBands) {
            this.targetBands = StringListInputCopier.copy(targetBands);
        }

        @Override
        public final Builder targetBands(Collection<String> targetBands) {
            this.targetBands = StringListInputCopier.copy(targetBands);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetBands(String ... targetBands) {
            this.targetBands(Arrays.asList(targetBands));
            return this;
        }

        public CloudRemovalConfigInput build() {
            return new CloudRemovalConfigInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CloudRemovalConfigInput> {
        public Builder algorithmName(String var1);

        public Builder algorithmName(AlgorithmNameCloudRemoval var1);

        public Builder interpolationValue(String var1);

        public Builder targetBands(Collection<String> var1);

        public Builder targetBands(String ... var1);
    }
}

