/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakergeospatial.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemakergeospatial.SageMakerGeospatialClient;
import software.amazon.awssdk.services.sagemakergeospatial.model.SearchRasterDataCollectionRequest;
import software.amazon.awssdk.services.sagemakergeospatial.model.SearchRasterDataCollectionResponse;

public class SearchRasterDataCollectionIterable
implements SdkIterable<SearchRasterDataCollectionResponse> {
    private final SageMakerGeospatialClient client;
    private final SearchRasterDataCollectionRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchRasterDataCollectionIterable(SageMakerGeospatialClient client, SearchRasterDataCollectionRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new SearchRasterDataCollectionResponseFetcher();
    }

    public Iterator<SearchRasterDataCollectionResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class SearchRasterDataCollectionResponseFetcher
    implements SyncPageFetcher<SearchRasterDataCollectionResponse> {
        private SearchRasterDataCollectionResponseFetcher() {
        }

        public boolean hasNextPage(SearchRasterDataCollectionResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchRasterDataCollectionResponse nextPage(SearchRasterDataCollectionResponse previousPage) {
            if (previousPage == null) {
                return SearchRasterDataCollectionIterable.this.client.searchRasterDataCollection(SearchRasterDataCollectionIterable.this.firstRequest);
            }
            return SearchRasterDataCollectionIterable.this.client.searchRasterDataCollection((SearchRasterDataCollectionRequest)((Object)SearchRasterDataCollectionIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

