/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakeredge;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.sagemakeredge.model.GetDeviceRegistrationRequest;
import software.amazon.awssdk.services.sagemakeredge.model.GetDeviceRegistrationResponse;
import software.amazon.awssdk.services.sagemakeredge.model.InternalServiceException;
import software.amazon.awssdk.services.sagemakeredge.model.SagemakerEdgeException;
import software.amazon.awssdk.services.sagemakeredge.model.SendHeartbeatRequest;
import software.amazon.awssdk.services.sagemakeredge.model.SendHeartbeatResponse;

/**
 * Service client for accessing Amazon Sagemaker Edge Manager. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * SageMaker Edge Manager dataplane service for communicating with active agents.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface SagemakerEdgeClient extends SdkClient {
    String SERVICE_NAME = "sagemaker";

    /**
     * Create a {@link SagemakerEdgeClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SagemakerEdgeClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SagemakerEdgeClient}.
     */
    static SagemakerEdgeClientBuilder builder() {
        return new DefaultSagemakerEdgeClientBuilder();
    }

    /**
     * <p>
     * Use to check if a device is registered with SageMaker Edge Manager.
     * </p>
     *
     * @param getDeviceRegistrationRequest
     * @return Result of the GetDeviceRegistration operation returned by the service.
     * @throws InternalServiceException
     *         An internal failure occurred. Try your request again. If the problem persists, contact AWS customer
     *         support.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SagemakerEdgeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SagemakerEdgeClient.GetDeviceRegistration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-edge-2020-09-23/GetDeviceRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDeviceRegistrationResponse getDeviceRegistration(GetDeviceRegistrationRequest getDeviceRegistrationRequest)
            throws InternalServiceException, AwsServiceException, SdkClientException, SagemakerEdgeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use to check if a device is registered with SageMaker Edge Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeviceRegistrationRequest.Builder} avoiding the
     * need to create one manually via {@link GetDeviceRegistrationRequest#builder()}
     * </p>
     *
     * @param getDeviceRegistrationRequest
     *        A {@link Consumer} that will call methods on {@link GetDeviceRegistrationRequest.Builder} to create a
     *        request.
     * @return Result of the GetDeviceRegistration operation returned by the service.
     * @throws InternalServiceException
     *         An internal failure occurred. Try your request again. If the problem persists, contact AWS customer
     *         support.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SagemakerEdgeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SagemakerEdgeClient.GetDeviceRegistration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-edge-2020-09-23/GetDeviceRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDeviceRegistrationResponse getDeviceRegistration(
            Consumer<GetDeviceRegistrationRequest.Builder> getDeviceRegistrationRequest) throws InternalServiceException,
            AwsServiceException, SdkClientException, SagemakerEdgeException {
        return getDeviceRegistration(GetDeviceRegistrationRequest.builder().applyMutation(getDeviceRegistrationRequest).build());
    }

    /**
     * <p>
     * Use to get the current status of devices registered on SageMaker Edge Manager.
     * </p>
     *
     * @param sendHeartbeatRequest
     * @return Result of the SendHeartbeat operation returned by the service.
     * @throws InternalServiceException
     *         An internal failure occurred. Try your request again. If the problem persists, contact AWS customer
     *         support.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SagemakerEdgeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SagemakerEdgeClient.SendHeartbeat
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-edge-2020-09-23/SendHeartbeat" target="_top">AWS
     *      API Documentation</a>
     */
    default SendHeartbeatResponse sendHeartbeat(SendHeartbeatRequest sendHeartbeatRequest) throws InternalServiceException,
            AwsServiceException, SdkClientException, SagemakerEdgeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use to get the current status of devices registered on SageMaker Edge Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendHeartbeatRequest.Builder} avoiding the need to
     * create one manually via {@link SendHeartbeatRequest#builder()}
     * </p>
     *
     * @param sendHeartbeatRequest
     *        A {@link Consumer} that will call methods on {@link SendHeartbeatRequest.Builder} to create a request.
     * @return Result of the SendHeartbeat operation returned by the service.
     * @throws InternalServiceException
     *         An internal failure occurred. Try your request again. If the problem persists, contact AWS customer
     *         support.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SagemakerEdgeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SagemakerEdgeClient.SendHeartbeat
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-edge-2020-09-23/SendHeartbeat" target="_top">AWS
     *      API Documentation</a>
     */
    default SendHeartbeatResponse sendHeartbeat(Consumer<SendHeartbeatRequest.Builder> sendHeartbeatRequest)
            throws InternalServiceException, AwsServiceException, SdkClientException, SagemakerEdgeException {
        return sendHeartbeat(SendHeartbeatRequest.builder().applyMutation(sendHeartbeatRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("edge.sagemaker");
    }
}
