/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakera2iruntime.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemakera2iruntime.SageMakerA2IRuntimeAsyncClient;
import software.amazon.awssdk.services.sagemakera2iruntime.model.HumanLoopSummary;
import software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsRequest;
import software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsResponse;

public class ListHumanLoopsPublisher
implements SdkPublisher<ListHumanLoopsResponse> {
    private final SageMakerA2IRuntimeAsyncClient client;
    private final ListHumanLoopsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListHumanLoopsPublisher(SageMakerA2IRuntimeAsyncClient client, ListHumanLoopsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListHumanLoopsPublisher(SageMakerA2IRuntimeAsyncClient client, ListHumanLoopsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListHumanLoopsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListHumanLoopsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<HumanLoopSummary> humanLoopSummaries() {
        Function<ListHumanLoopsResponse, Iterator> getIterator = response -> {
            if (response != null && response.humanLoopSummaries() != null) {
                return response.humanLoopSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListHumanLoopsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListHumanLoopsResponseFetcher
    implements AsyncPageFetcher<ListHumanLoopsResponse> {
        private ListHumanLoopsResponseFetcher() {
        }

        public boolean hasNextPage(ListHumanLoopsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListHumanLoopsResponse> nextPage(ListHumanLoopsResponse previousPage) {
            if (previousPage == null) {
                return ListHumanLoopsPublisher.this.client.listHumanLoops(ListHumanLoopsPublisher.this.firstRequest);
            }
            return ListHumanLoopsPublisher.this.client.listHumanLoops((ListHumanLoopsRequest)((Object)ListHumanLoopsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

