/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ListMlflowAppsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListMlflowAppsResponse;
import software.amazon.awssdk.services.sagemaker.model.MlflowAppSummary;

public class ListMlflowAppsPublisher
implements SdkPublisher<ListMlflowAppsResponse> {
    private final SageMakerAsyncClient client;
    private final ListMlflowAppsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMlflowAppsPublisher(SageMakerAsyncClient client, ListMlflowAppsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMlflowAppsPublisher(SageMakerAsyncClient client, ListMlflowAppsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMlflowAppsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMlflowAppsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MlflowAppSummary> summaries() {
        Function<ListMlflowAppsResponse, Iterator> getIterator = response -> {
            if (response != null && response.summaries() != null) {
                return response.summaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListMlflowAppsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListMlflowAppsResponseFetcher
    implements AsyncPageFetcher<ListMlflowAppsResponse> {
        private ListMlflowAppsResponseFetcher() {
        }

        public boolean hasNextPage(ListMlflowAppsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMlflowAppsResponse> nextPage(ListMlflowAppsResponse previousPage) {
            if (previousPage == null) {
                return ListMlflowAppsPublisher.this.client.listMlflowApps(ListMlflowAppsPublisher.this.firstRequest);
            }
            return ListMlflowAppsPublisher.this.client.listMlflowApps((ListMlflowAppsRequest)((Object)ListMlflowAppsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

