/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ClusterEventSummary;
import software.amazon.awssdk.services.sagemaker.model.ListClusterEventsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListClusterEventsResponse;

public class ListClusterEventsPublisher
implements SdkPublisher<ListClusterEventsResponse> {
    private final SageMakerAsyncClient client;
    private final ListClusterEventsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListClusterEventsPublisher(SageMakerAsyncClient client, ListClusterEventsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListClusterEventsPublisher(SageMakerAsyncClient client, ListClusterEventsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListClusterEventsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListClusterEventsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ClusterEventSummary> events() {
        Function<ListClusterEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.events() != null) {
                return response.events().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListClusterEventsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListClusterEventsResponseFetcher
    implements AsyncPageFetcher<ListClusterEventsResponse> {
        private ListClusterEventsResponseFetcher() {
        }

        public boolean hasNextPage(ListClusterEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListClusterEventsResponse> nextPage(ListClusterEventsResponse previousPage) {
            if (previousPage == null) {
                return ListClusterEventsPublisher.this.client.listClusterEvents(ListClusterEventsPublisher.this.firstRequest);
            }
            return ListClusterEventsPublisher.this.client.listClusterEvents((ListClusterEventsRequest)((Object)ListClusterEventsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

