/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.AdditionalInferenceSpecificationDefinition;
import software.amazon.awssdk.services.sagemaker.model.AdditionalInferenceSpecificationsCopier;
import software.amazon.awssdk.services.sagemaker.model.CustomerMetadataKeyListCopier;
import software.amazon.awssdk.services.sagemaker.model.CustomerMetadataMapCopier;
import software.amazon.awssdk.services.sagemaker.model.InferenceSpecification;
import software.amazon.awssdk.services.sagemaker.model.ModelApprovalStatus;
import software.amazon.awssdk.services.sagemaker.model.ModelLifeCycle;
import software.amazon.awssdk.services.sagemaker.model.ModelPackageModelCard;
import software.amazon.awssdk.services.sagemaker.model.ModelPackageRegistrationType;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateModelPackageRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, UpdateModelPackageRequest> {
    private static final SdkField<String> MODEL_PACKAGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelPackageArn").getter(UpdateModelPackageRequest.getter(UpdateModelPackageRequest::modelPackageArn)).setter(UpdateModelPackageRequest.setter(Builder::modelPackageArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageArn").build()}).build();
    private static final SdkField<String> MODEL_APPROVAL_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelApprovalStatus").getter(UpdateModelPackageRequest.getter(UpdateModelPackageRequest::modelApprovalStatusAsString)).setter(UpdateModelPackageRequest.setter(Builder::modelApprovalStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelApprovalStatus").build()}).build();
    private static final SdkField<String> MODEL_PACKAGE_REGISTRATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelPackageRegistrationType").getter(UpdateModelPackageRequest.getter(UpdateModelPackageRequest::modelPackageRegistrationTypeAsString)).setter(UpdateModelPackageRequest.setter(Builder::modelPackageRegistrationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageRegistrationType").build()}).build();
    private static final SdkField<String> APPROVAL_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApprovalDescription").getter(UpdateModelPackageRequest.getter(UpdateModelPackageRequest::approvalDescription)).setter(UpdateModelPackageRequest.setter(Builder::approvalDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovalDescription").build()}).build();
    private static final SdkField<Map<String, String>> CUSTOMER_METADATA_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("CustomerMetadataProperties").getter(UpdateModelPackageRequest.getter(UpdateModelPackageRequest::customerMetadataProperties)).setter(UpdateModelPackageRequest.setter(Builder::customerMetadataProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerMetadataProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CUSTOMER_METADATA_PROPERTIES_TO_REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CustomerMetadataPropertiesToRemove").getter(UpdateModelPackageRequest.getter(UpdateModelPackageRequest::customerMetadataPropertiesToRemove)).setter(UpdateModelPackageRequest.setter(Builder::customerMetadataPropertiesToRemove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerMetadataPropertiesToRemove").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AdditionalInferenceSpecificationDefinition>> ADDITIONAL_INFERENCE_SPECIFICATIONS_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalInferenceSpecificationsToAdd").getter(UpdateModelPackageRequest.getter(UpdateModelPackageRequest::additionalInferenceSpecificationsToAdd)).setter(UpdateModelPackageRequest.setter(Builder::additionalInferenceSpecificationsToAdd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalInferenceSpecificationsToAdd").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AdditionalInferenceSpecificationDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<InferenceSpecification> INFERENCE_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InferenceSpecification").getter(UpdateModelPackageRequest.getter(UpdateModelPackageRequest::inferenceSpecification)).setter(UpdateModelPackageRequest.setter(Builder::inferenceSpecification)).constructor(InferenceSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSpecification").build()}).build();
    private static final SdkField<String> SOURCE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceUri").getter(UpdateModelPackageRequest.getter(UpdateModelPackageRequest::sourceUri)).setter(UpdateModelPackageRequest.setter(Builder::sourceUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceUri").build()}).build();
    private static final SdkField<ModelPackageModelCard> MODEL_CARD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelCard").getter(UpdateModelPackageRequest.getter(UpdateModelPackageRequest::modelCard)).setter(UpdateModelPackageRequest.setter(Builder::modelCard)).constructor(ModelPackageModelCard::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCard").build()}).build();
    private static final SdkField<ModelLifeCycle> MODEL_LIFE_CYCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelLifeCycle").getter(UpdateModelPackageRequest.getter(UpdateModelPackageRequest::modelLifeCycle)).setter(UpdateModelPackageRequest.setter(Builder::modelLifeCycle)).constructor(ModelLifeCycle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelLifeCycle").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(UpdateModelPackageRequest.getter(UpdateModelPackageRequest::clientToken)).setter(UpdateModelPackageRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_PACKAGE_ARN_FIELD, MODEL_APPROVAL_STATUS_FIELD, MODEL_PACKAGE_REGISTRATION_TYPE_FIELD, APPROVAL_DESCRIPTION_FIELD, CUSTOMER_METADATA_PROPERTIES_FIELD, CUSTOMER_METADATA_PROPERTIES_TO_REMOVE_FIELD, ADDITIONAL_INFERENCE_SPECIFICATIONS_TO_ADD_FIELD, INFERENCE_SPECIFICATION_FIELD, SOURCE_URI_FIELD, MODEL_CARD_FIELD, MODEL_LIFE_CYCLE_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateModelPackageRequest.memberNameToFieldInitializer();
    private final String modelPackageArn;
    private final String modelApprovalStatus;
    private final String modelPackageRegistrationType;
    private final String approvalDescription;
    private final Map<String, String> customerMetadataProperties;
    private final List<String> customerMetadataPropertiesToRemove;
    private final List<AdditionalInferenceSpecificationDefinition> additionalInferenceSpecificationsToAdd;
    private final InferenceSpecification inferenceSpecification;
    private final String sourceUri;
    private final ModelPackageModelCard modelCard;
    private final ModelLifeCycle modelLifeCycle;
    private final String clientToken;

    private UpdateModelPackageRequest(BuilderImpl builder) {
        super(builder);
        this.modelPackageArn = builder.modelPackageArn;
        this.modelApprovalStatus = builder.modelApprovalStatus;
        this.modelPackageRegistrationType = builder.modelPackageRegistrationType;
        this.approvalDescription = builder.approvalDescription;
        this.customerMetadataProperties = builder.customerMetadataProperties;
        this.customerMetadataPropertiesToRemove = builder.customerMetadataPropertiesToRemove;
        this.additionalInferenceSpecificationsToAdd = builder.additionalInferenceSpecificationsToAdd;
        this.inferenceSpecification = builder.inferenceSpecification;
        this.sourceUri = builder.sourceUri;
        this.modelCard = builder.modelCard;
        this.modelLifeCycle = builder.modelLifeCycle;
        this.clientToken = builder.clientToken;
    }

    public final String modelPackageArn() {
        return this.modelPackageArn;
    }

    public final ModelApprovalStatus modelApprovalStatus() {
        return ModelApprovalStatus.fromValue(this.modelApprovalStatus);
    }

    public final String modelApprovalStatusAsString() {
        return this.modelApprovalStatus;
    }

    public final ModelPackageRegistrationType modelPackageRegistrationType() {
        return ModelPackageRegistrationType.fromValue(this.modelPackageRegistrationType);
    }

    public final String modelPackageRegistrationTypeAsString() {
        return this.modelPackageRegistrationType;
    }

    public final String approvalDescription() {
        return this.approvalDescription;
    }

    public final boolean hasCustomerMetadataProperties() {
        return this.customerMetadataProperties != null && !(this.customerMetadataProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> customerMetadataProperties() {
        return this.customerMetadataProperties;
    }

    public final boolean hasCustomerMetadataPropertiesToRemove() {
        return this.customerMetadataPropertiesToRemove != null && !(this.customerMetadataPropertiesToRemove instanceof SdkAutoConstructList);
    }

    public final List<String> customerMetadataPropertiesToRemove() {
        return this.customerMetadataPropertiesToRemove;
    }

    public final boolean hasAdditionalInferenceSpecificationsToAdd() {
        return this.additionalInferenceSpecificationsToAdd != null && !(this.additionalInferenceSpecificationsToAdd instanceof SdkAutoConstructList);
    }

    public final List<AdditionalInferenceSpecificationDefinition> additionalInferenceSpecificationsToAdd() {
        return this.additionalInferenceSpecificationsToAdd;
    }

    public final InferenceSpecification inferenceSpecification() {
        return this.inferenceSpecification;
    }

    public final String sourceUri() {
        return this.sourceUri;
    }

    public final ModelPackageModelCard modelCard() {
        return this.modelCard;
    }

    public final ModelLifeCycle modelLifeCycle() {
        return this.modelLifeCycle;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelApprovalStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageRegistrationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.approvalDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomerMetadataProperties() ? this.customerMetadataProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomerMetadataPropertiesToRemove() ? this.customerMetadataPropertiesToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalInferenceSpecificationsToAdd() ? this.additionalInferenceSpecificationsToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelCard());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelLifeCycle());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateModelPackageRequest)) {
            return false;
        }
        UpdateModelPackageRequest other = (UpdateModelPackageRequest)((Object)obj);
        return Objects.equals(this.modelPackageArn(), other.modelPackageArn()) && Objects.equals(this.modelApprovalStatusAsString(), other.modelApprovalStatusAsString()) && Objects.equals(this.modelPackageRegistrationTypeAsString(), other.modelPackageRegistrationTypeAsString()) && Objects.equals(this.approvalDescription(), other.approvalDescription()) && this.hasCustomerMetadataProperties() == other.hasCustomerMetadataProperties() && Objects.equals(this.customerMetadataProperties(), other.customerMetadataProperties()) && this.hasCustomerMetadataPropertiesToRemove() == other.hasCustomerMetadataPropertiesToRemove() && Objects.equals(this.customerMetadataPropertiesToRemove(), other.customerMetadataPropertiesToRemove()) && this.hasAdditionalInferenceSpecificationsToAdd() == other.hasAdditionalInferenceSpecificationsToAdd() && Objects.equals(this.additionalInferenceSpecificationsToAdd(), other.additionalInferenceSpecificationsToAdd()) && Objects.equals(this.inferenceSpecification(), other.inferenceSpecification()) && Objects.equals(this.sourceUri(), other.sourceUri()) && Objects.equals(this.modelCard(), other.modelCard()) && Objects.equals(this.modelLifeCycle(), other.modelLifeCycle()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateModelPackageRequest").add("ModelPackageArn", (Object)this.modelPackageArn()).add("ModelApprovalStatus", (Object)this.modelApprovalStatusAsString()).add("ModelPackageRegistrationType", (Object)this.modelPackageRegistrationTypeAsString()).add("ApprovalDescription", (Object)this.approvalDescription()).add("CustomerMetadataProperties", this.hasCustomerMetadataProperties() ? this.customerMetadataProperties() : null).add("CustomerMetadataPropertiesToRemove", this.hasCustomerMetadataPropertiesToRemove() ? this.customerMetadataPropertiesToRemove() : null).add("AdditionalInferenceSpecificationsToAdd", this.hasAdditionalInferenceSpecificationsToAdd() ? this.additionalInferenceSpecificationsToAdd() : null).add("InferenceSpecification", (Object)this.inferenceSpecification()).add("SourceUri", (Object)this.sourceUri()).add("ModelCard", (Object)this.modelCard()).add("ModelLifeCycle", (Object)this.modelLifeCycle()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelPackageArn": {
                return Optional.ofNullable(clazz.cast(this.modelPackageArn()));
            }
            case "ModelApprovalStatus": {
                return Optional.ofNullable(clazz.cast(this.modelApprovalStatusAsString()));
            }
            case "ModelPackageRegistrationType": {
                return Optional.ofNullable(clazz.cast(this.modelPackageRegistrationTypeAsString()));
            }
            case "ApprovalDescription": {
                return Optional.ofNullable(clazz.cast(this.approvalDescription()));
            }
            case "CustomerMetadataProperties": {
                return Optional.ofNullable(clazz.cast(this.customerMetadataProperties()));
            }
            case "CustomerMetadataPropertiesToRemove": {
                return Optional.ofNullable(clazz.cast(this.customerMetadataPropertiesToRemove()));
            }
            case "AdditionalInferenceSpecificationsToAdd": {
                return Optional.ofNullable(clazz.cast(this.additionalInferenceSpecificationsToAdd()));
            }
            case "InferenceSpecification": {
                return Optional.ofNullable(clazz.cast(this.inferenceSpecification()));
            }
            case "SourceUri": {
                return Optional.ofNullable(clazz.cast(this.sourceUri()));
            }
            case "ModelCard": {
                return Optional.ofNullable(clazz.cast(this.modelCard()));
            }
            case "ModelLifeCycle": {
                return Optional.ofNullable(clazz.cast(this.modelLifeCycle()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ModelPackageArn", MODEL_PACKAGE_ARN_FIELD);
        map.put("ModelApprovalStatus", MODEL_APPROVAL_STATUS_FIELD);
        map.put("ModelPackageRegistrationType", MODEL_PACKAGE_REGISTRATION_TYPE_FIELD);
        map.put("ApprovalDescription", APPROVAL_DESCRIPTION_FIELD);
        map.put("CustomerMetadataProperties", CUSTOMER_METADATA_PROPERTIES_FIELD);
        map.put("CustomerMetadataPropertiesToRemove", CUSTOMER_METADATA_PROPERTIES_TO_REMOVE_FIELD);
        map.put("AdditionalInferenceSpecificationsToAdd", ADDITIONAL_INFERENCE_SPECIFICATIONS_TO_ADD_FIELD);
        map.put("InferenceSpecification", INFERENCE_SPECIFICATION_FIELD);
        map.put("SourceUri", SOURCE_URI_FIELD);
        map.put("ModelCard", MODEL_CARD_FIELD);
        map.put("ModelLifeCycle", MODEL_LIFE_CYCLE_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateModelPackageRequest, T> g) {
        return obj -> g.apply((UpdateModelPackageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String modelPackageArn;
        private String modelApprovalStatus;
        private String modelPackageRegistrationType;
        private String approvalDescription;
        private Map<String, String> customerMetadataProperties = DefaultSdkAutoConstructMap.getInstance();
        private List<String> customerMetadataPropertiesToRemove = DefaultSdkAutoConstructList.getInstance();
        private List<AdditionalInferenceSpecificationDefinition> additionalInferenceSpecificationsToAdd = DefaultSdkAutoConstructList.getInstance();
        private InferenceSpecification inferenceSpecification;
        private String sourceUri;
        private ModelPackageModelCard modelCard;
        private ModelLifeCycle modelLifeCycle;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateModelPackageRequest model) {
            super(model);
            this.modelPackageArn(model.modelPackageArn);
            this.modelApprovalStatus(model.modelApprovalStatus);
            this.modelPackageRegistrationType(model.modelPackageRegistrationType);
            this.approvalDescription(model.approvalDescription);
            this.customerMetadataProperties(model.customerMetadataProperties);
            this.customerMetadataPropertiesToRemove(model.customerMetadataPropertiesToRemove);
            this.additionalInferenceSpecificationsToAdd(model.additionalInferenceSpecificationsToAdd);
            this.inferenceSpecification(model.inferenceSpecification);
            this.sourceUri(model.sourceUri);
            this.modelCard(model.modelCard);
            this.modelLifeCycle(model.modelLifeCycle);
            this.clientToken(model.clientToken);
        }

        public final String getModelPackageArn() {
            return this.modelPackageArn;
        }

        public final void setModelPackageArn(String modelPackageArn) {
            this.modelPackageArn = modelPackageArn;
        }

        @Override
        public final Builder modelPackageArn(String modelPackageArn) {
            this.modelPackageArn = modelPackageArn;
            return this;
        }

        public final String getModelApprovalStatus() {
            return this.modelApprovalStatus;
        }

        public final void setModelApprovalStatus(String modelApprovalStatus) {
            this.modelApprovalStatus = modelApprovalStatus;
        }

        @Override
        public final Builder modelApprovalStatus(String modelApprovalStatus) {
            this.modelApprovalStatus = modelApprovalStatus;
            return this;
        }

        @Override
        public final Builder modelApprovalStatus(ModelApprovalStatus modelApprovalStatus) {
            this.modelApprovalStatus(modelApprovalStatus == null ? null : modelApprovalStatus.toString());
            return this;
        }

        public final String getModelPackageRegistrationType() {
            return this.modelPackageRegistrationType;
        }

        public final void setModelPackageRegistrationType(String modelPackageRegistrationType) {
            this.modelPackageRegistrationType = modelPackageRegistrationType;
        }

        @Override
        public final Builder modelPackageRegistrationType(String modelPackageRegistrationType) {
            this.modelPackageRegistrationType = modelPackageRegistrationType;
            return this;
        }

        @Override
        public final Builder modelPackageRegistrationType(ModelPackageRegistrationType modelPackageRegistrationType) {
            this.modelPackageRegistrationType(modelPackageRegistrationType == null ? null : modelPackageRegistrationType.toString());
            return this;
        }

        public final String getApprovalDescription() {
            return this.approvalDescription;
        }

        public final void setApprovalDescription(String approvalDescription) {
            this.approvalDescription = approvalDescription;
        }

        @Override
        public final Builder approvalDescription(String approvalDescription) {
            this.approvalDescription = approvalDescription;
            return this;
        }

        public final Map<String, String> getCustomerMetadataProperties() {
            if (this.customerMetadataProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.customerMetadataProperties;
        }

        public final void setCustomerMetadataProperties(Map<String, String> customerMetadataProperties) {
            this.customerMetadataProperties = CustomerMetadataMapCopier.copy(customerMetadataProperties);
        }

        @Override
        public final Builder customerMetadataProperties(Map<String, String> customerMetadataProperties) {
            this.customerMetadataProperties = CustomerMetadataMapCopier.copy(customerMetadataProperties);
            return this;
        }

        public final Collection<String> getCustomerMetadataPropertiesToRemove() {
            if (this.customerMetadataPropertiesToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return this.customerMetadataPropertiesToRemove;
        }

        public final void setCustomerMetadataPropertiesToRemove(Collection<String> customerMetadataPropertiesToRemove) {
            this.customerMetadataPropertiesToRemove = CustomerMetadataKeyListCopier.copy(customerMetadataPropertiesToRemove);
        }

        @Override
        public final Builder customerMetadataPropertiesToRemove(Collection<String> customerMetadataPropertiesToRemove) {
            this.customerMetadataPropertiesToRemove = CustomerMetadataKeyListCopier.copy(customerMetadataPropertiesToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customerMetadataPropertiesToRemove(String ... customerMetadataPropertiesToRemove) {
            this.customerMetadataPropertiesToRemove(Arrays.asList(customerMetadataPropertiesToRemove));
            return this;
        }

        public final List<AdditionalInferenceSpecificationDefinition.Builder> getAdditionalInferenceSpecificationsToAdd() {
            List<AdditionalInferenceSpecificationDefinition.Builder> result = AdditionalInferenceSpecificationsCopier.copyToBuilder(this.additionalInferenceSpecificationsToAdd);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalInferenceSpecificationsToAdd(Collection<AdditionalInferenceSpecificationDefinition.BuilderImpl> additionalInferenceSpecificationsToAdd) {
            this.additionalInferenceSpecificationsToAdd = AdditionalInferenceSpecificationsCopier.copyFromBuilder(additionalInferenceSpecificationsToAdd);
        }

        @Override
        public final Builder additionalInferenceSpecificationsToAdd(Collection<AdditionalInferenceSpecificationDefinition> additionalInferenceSpecificationsToAdd) {
            this.additionalInferenceSpecificationsToAdd = AdditionalInferenceSpecificationsCopier.copy(additionalInferenceSpecificationsToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalInferenceSpecificationsToAdd(AdditionalInferenceSpecificationDefinition ... additionalInferenceSpecificationsToAdd) {
            this.additionalInferenceSpecificationsToAdd(Arrays.asList(additionalInferenceSpecificationsToAdd));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalInferenceSpecificationsToAdd(Consumer<AdditionalInferenceSpecificationDefinition.Builder> ... additionalInferenceSpecificationsToAdd) {
            this.additionalInferenceSpecificationsToAdd(Stream.of(additionalInferenceSpecificationsToAdd).map(c -> (AdditionalInferenceSpecificationDefinition)((AdditionalInferenceSpecificationDefinition.Builder)AdditionalInferenceSpecificationDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final InferenceSpecification.Builder getInferenceSpecification() {
            return this.inferenceSpecification != null ? this.inferenceSpecification.toBuilder() : null;
        }

        public final void setInferenceSpecification(InferenceSpecification.BuilderImpl inferenceSpecification) {
            this.inferenceSpecification = inferenceSpecification != null ? inferenceSpecification.build() : null;
        }

        @Override
        public final Builder inferenceSpecification(InferenceSpecification inferenceSpecification) {
            this.inferenceSpecification = inferenceSpecification;
            return this;
        }

        public final String getSourceUri() {
            return this.sourceUri;
        }

        public final void setSourceUri(String sourceUri) {
            this.sourceUri = sourceUri;
        }

        @Override
        public final Builder sourceUri(String sourceUri) {
            this.sourceUri = sourceUri;
            return this;
        }

        public final ModelPackageModelCard.Builder getModelCard() {
            return this.modelCard != null ? this.modelCard.toBuilder() : null;
        }

        public final void setModelCard(ModelPackageModelCard.BuilderImpl modelCard) {
            this.modelCard = modelCard != null ? modelCard.build() : null;
        }

        @Override
        public final Builder modelCard(ModelPackageModelCard modelCard) {
            this.modelCard = modelCard;
            return this;
        }

        public final ModelLifeCycle.Builder getModelLifeCycle() {
            return this.modelLifeCycle != null ? this.modelLifeCycle.toBuilder() : null;
        }

        public final void setModelLifeCycle(ModelLifeCycle.BuilderImpl modelLifeCycle) {
            this.modelLifeCycle = modelLifeCycle != null ? modelLifeCycle.build() : null;
        }

        @Override
        public final Builder modelLifeCycle(ModelLifeCycle modelLifeCycle) {
            this.modelLifeCycle = modelLifeCycle;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateModelPackageRequest build() {
            return new UpdateModelPackageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateModelPackageRequest> {
        public Builder modelPackageArn(String var1);

        public Builder modelApprovalStatus(String var1);

        public Builder modelApprovalStatus(ModelApprovalStatus var1);

        public Builder modelPackageRegistrationType(String var1);

        public Builder modelPackageRegistrationType(ModelPackageRegistrationType var1);

        public Builder approvalDescription(String var1);

        public Builder customerMetadataProperties(Map<String, String> var1);

        public Builder customerMetadataPropertiesToRemove(Collection<String> var1);

        public Builder customerMetadataPropertiesToRemove(String ... var1);

        public Builder additionalInferenceSpecificationsToAdd(Collection<AdditionalInferenceSpecificationDefinition> var1);

        public Builder additionalInferenceSpecificationsToAdd(AdditionalInferenceSpecificationDefinition ... var1);

        public Builder additionalInferenceSpecificationsToAdd(Consumer<AdditionalInferenceSpecificationDefinition.Builder> ... var1);

        public Builder inferenceSpecification(InferenceSpecification var1);

        default public Builder inferenceSpecification(Consumer<InferenceSpecification.Builder> inferenceSpecification) {
            return this.inferenceSpecification((InferenceSpecification)((InferenceSpecification.Builder)InferenceSpecification.builder().applyMutation(inferenceSpecification)).build());
        }

        public Builder sourceUri(String var1);

        public Builder modelCard(ModelPackageModelCard var1);

        default public Builder modelCard(Consumer<ModelPackageModelCard.Builder> modelCard) {
            return this.modelCard((ModelPackageModelCard)((ModelPackageModelCard.Builder)ModelPackageModelCard.builder().applyMutation(modelCard)).build());
        }

        public Builder modelLifeCycle(ModelLifeCycle var1);

        default public Builder modelLifeCycle(Consumer<ModelLifeCycle.Builder> modelLifeCycle) {
            return this.modelLifeCycle((ModelLifeCycle)((ModelLifeCycle.Builder)ModelLifeCycle.builder().applyMutation(modelLifeCycle)).build());
        }

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

