/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ServerlessJobType {
    FINE_TUNING("FineTuning"),
    EVALUATION("Evaluation"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ServerlessJobType> VALUE_MAP;
    private final String value;

    private ServerlessJobType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ServerlessJobType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ServerlessJobType> knownValues() {
        EnumSet<ServerlessJobType> knownValues = EnumSet.allOf(ServerlessJobType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ServerlessJobType.class, ServerlessJobType::toString);
    }
}

