/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PlacementSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PlacementSpecification> {
    private static final SdkField<String> ULTRA_SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UltraServerId").getter(PlacementSpecification.getter(PlacementSpecification::ultraServerId)).setter(PlacementSpecification.setter(Builder::ultraServerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UltraServerId").build()}).build();
    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstanceCount").getter(PlacementSpecification.getter(PlacementSpecification::instanceCount)).setter(PlacementSpecification.setter(Builder::instanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ULTRA_SERVER_ID_FIELD, INSTANCE_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PlacementSpecification.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String ultraServerId;
    private final Integer instanceCount;

    private PlacementSpecification(BuilderImpl builder) {
        this.ultraServerId = builder.ultraServerId;
        this.instanceCount = builder.instanceCount;
    }

    public final String ultraServerId() {
        return this.ultraServerId;
    }

    public final Integer instanceCount() {
        return this.instanceCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ultraServerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlacementSpecification)) {
            return false;
        }
        PlacementSpecification other = (PlacementSpecification)obj;
        return Objects.equals(this.ultraServerId(), other.ultraServerId()) && Objects.equals(this.instanceCount(), other.instanceCount());
    }

    public final String toString() {
        return ToString.builder((String)"PlacementSpecification").add("UltraServerId", (Object)this.ultraServerId()).add("InstanceCount", (Object)this.instanceCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UltraServerId": {
                return Optional.ofNullable(clazz.cast(this.ultraServerId()));
            }
            case "InstanceCount": {
                return Optional.ofNullable(clazz.cast(this.instanceCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("UltraServerId", ULTRA_SERVER_ID_FIELD);
        map.put("InstanceCount", INSTANCE_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PlacementSpecification, T> g) {
        return obj -> g.apply((PlacementSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ultraServerId;
        private Integer instanceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(PlacementSpecification model) {
            this.ultraServerId(model.ultraServerId);
            this.instanceCount(model.instanceCount);
        }

        public final String getUltraServerId() {
            return this.ultraServerId;
        }

        public final void setUltraServerId(String ultraServerId) {
            this.ultraServerId = ultraServerId;
        }

        @Override
        public final Builder ultraServerId(String ultraServerId) {
            this.ultraServerId = ultraServerId;
            return this;
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public PlacementSpecification build() {
            return new PlacementSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PlacementSpecification> {
        public Builder ultraServerId(String var1);

        public Builder instanceCount(Integer var1);
    }
}

