/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.MonitoringAlertSummary;
import software.amazon.awssdk.services.sagemaker.model.MonitoringAlertSummaryListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMonitoringAlertsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListMonitoringAlertsResponse> {
    private static final SdkField<List<MonitoringAlertSummary>> MONITORING_ALERT_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MonitoringAlertSummaries").getter(ListMonitoringAlertsResponse.getter(ListMonitoringAlertsResponse::monitoringAlertSummaries)).setter(ListMonitoringAlertsResponse.setter(Builder::monitoringAlertSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringAlertSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MonitoringAlertSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListMonitoringAlertsResponse.getter(ListMonitoringAlertsResponse::nextToken)).setter(ListMonitoringAlertsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITORING_ALERT_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListMonitoringAlertsResponse.memberNameToFieldInitializer();
    private final List<MonitoringAlertSummary> monitoringAlertSummaries;
    private final String nextToken;

    private ListMonitoringAlertsResponse(BuilderImpl builder) {
        super(builder);
        this.monitoringAlertSummaries = builder.monitoringAlertSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasMonitoringAlertSummaries() {
        return this.monitoringAlertSummaries != null && !(this.monitoringAlertSummaries instanceof SdkAutoConstructList);
    }

    public final List<MonitoringAlertSummary> monitoringAlertSummaries() {
        return this.monitoringAlertSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMonitoringAlertSummaries() ? this.monitoringAlertSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMonitoringAlertsResponse)) {
            return false;
        }
        ListMonitoringAlertsResponse other = (ListMonitoringAlertsResponse)((Object)obj);
        return this.hasMonitoringAlertSummaries() == other.hasMonitoringAlertSummaries() && Objects.equals(this.monitoringAlertSummaries(), other.monitoringAlertSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListMonitoringAlertsResponse").add("MonitoringAlertSummaries", this.hasMonitoringAlertSummaries() ? this.monitoringAlertSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MonitoringAlertSummaries": {
                return Optional.ofNullable(clazz.cast(this.monitoringAlertSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MonitoringAlertSummaries", MONITORING_ALERT_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMonitoringAlertsResponse, T> g) {
        return obj -> g.apply((ListMonitoringAlertsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<MonitoringAlertSummary> monitoringAlertSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMonitoringAlertsResponse model) {
            super(model);
            this.monitoringAlertSummaries(model.monitoringAlertSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<MonitoringAlertSummary.Builder> getMonitoringAlertSummaries() {
            List<MonitoringAlertSummary.Builder> result = MonitoringAlertSummaryListCopier.copyToBuilder(this.monitoringAlertSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMonitoringAlertSummaries(Collection<MonitoringAlertSummary.BuilderImpl> monitoringAlertSummaries) {
            this.monitoringAlertSummaries = MonitoringAlertSummaryListCopier.copyFromBuilder(monitoringAlertSummaries);
        }

        @Override
        public final Builder monitoringAlertSummaries(Collection<MonitoringAlertSummary> monitoringAlertSummaries) {
            this.monitoringAlertSummaries = MonitoringAlertSummaryListCopier.copy(monitoringAlertSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder monitoringAlertSummaries(MonitoringAlertSummary ... monitoringAlertSummaries) {
            this.monitoringAlertSummaries(Arrays.asList(monitoringAlertSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder monitoringAlertSummaries(Consumer<MonitoringAlertSummary.Builder> ... monitoringAlertSummaries) {
            this.monitoringAlertSummaries(Stream.of(monitoringAlertSummaries).map(c -> (MonitoringAlertSummary)((MonitoringAlertSummary.Builder)MonitoringAlertSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListMonitoringAlertsResponse build() {
            return new ListMonitoringAlertsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMonitoringAlertsResponse> {
        public Builder monitoringAlertSummaries(Collection<MonitoringAlertSummary> var1);

        public Builder monitoringAlertSummaries(MonitoringAlertSummary ... var1);

        public Builder monitoringAlertSummaries(Consumer<MonitoringAlertSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

