/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.ClusterKubernetesLabelsCopier;
import software.amazon.awssdk.services.sagemaker.model.ClusterKubernetesTaint;
import software.amazon.awssdk.services.sagemaker.model.ClusterKubernetesTaintsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusterKubernetesConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClusterKubernetesConfig> {
    private static final SdkField<Map<String, String>> LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Labels").getter(ClusterKubernetesConfig.getter(ClusterKubernetesConfig::labels)).setter(ClusterKubernetesConfig.setter(Builder::labels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Labels").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<ClusterKubernetesTaint>> TAINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Taints").getter(ClusterKubernetesConfig.getter(ClusterKubernetesConfig::taints)).setter(ClusterKubernetesConfig.setter(Builder::taints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Taints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClusterKubernetesTaint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABELS_FIELD, TAINTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ClusterKubernetesConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, String> labels;
    private final List<ClusterKubernetesTaint> taints;

    private ClusterKubernetesConfig(BuilderImpl builder) {
        this.labels = builder.labels;
        this.taints = builder.taints;
    }

    public final boolean hasLabels() {
        return this.labels != null && !(this.labels instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> labels() {
        return this.labels;
    }

    public final boolean hasTaints() {
        return this.taints != null && !(this.taints instanceof SdkAutoConstructList);
    }

    public final List<ClusterKubernetesTaint> taints() {
        return this.taints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLabels() ? this.labels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTaints() ? this.taints() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterKubernetesConfig)) {
            return false;
        }
        ClusterKubernetesConfig other = (ClusterKubernetesConfig)obj;
        return this.hasLabels() == other.hasLabels() && Objects.equals(this.labels(), other.labels()) && this.hasTaints() == other.hasTaints() && Objects.equals(this.taints(), other.taints());
    }

    public final String toString() {
        return ToString.builder((String)"ClusterKubernetesConfig").add("Labels", this.hasLabels() ? this.labels() : null).add("Taints", this.hasTaints() ? this.taints() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Labels": {
                return Optional.ofNullable(clazz.cast(this.labels()));
            }
            case "Taints": {
                return Optional.ofNullable(clazz.cast(this.taints()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Labels", LABELS_FIELD);
        map.put("Taints", TAINTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClusterKubernetesConfig, T> g) {
        return obj -> g.apply((ClusterKubernetesConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> labels = DefaultSdkAutoConstructMap.getInstance();
        private List<ClusterKubernetesTaint> taints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterKubernetesConfig model) {
            this.labels(model.labels);
            this.taints(model.taints);
        }

        public final Map<String, String> getLabels() {
            if (this.labels instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.labels;
        }

        public final void setLabels(Map<String, String> labels) {
            this.labels = ClusterKubernetesLabelsCopier.copy(labels);
        }

        @Override
        public final Builder labels(Map<String, String> labels) {
            this.labels = ClusterKubernetesLabelsCopier.copy(labels);
            return this;
        }

        public final List<ClusterKubernetesTaint.Builder> getTaints() {
            List<ClusterKubernetesTaint.Builder> result = ClusterKubernetesTaintsCopier.copyToBuilder(this.taints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTaints(Collection<ClusterKubernetesTaint.BuilderImpl> taints) {
            this.taints = ClusterKubernetesTaintsCopier.copyFromBuilder(taints);
        }

        @Override
        public final Builder taints(Collection<ClusterKubernetesTaint> taints) {
            this.taints = ClusterKubernetesTaintsCopier.copy(taints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taints(ClusterKubernetesTaint ... taints) {
            this.taints(Arrays.asList(taints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taints(Consumer<ClusterKubernetesTaint.Builder> ... taints) {
            this.taints(Stream.of(taints).map(c -> (ClusterKubernetesTaint)((ClusterKubernetesTaint.Builder)ClusterKubernetesTaint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ClusterKubernetesConfig build() {
            return new ClusterKubernetesConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClusterKubernetesConfig> {
        public Builder labels(Map<String, String> var1);

        public Builder taints(Collection<ClusterKubernetesTaint> var1);

        public Builder taints(ClusterKubernetesTaint ... var1);

        public Builder taints(Consumer<ClusterKubernetesTaint.Builder> ... var1);
    }
}

