/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.AlgorithmValidationProfile;
import software.amazon.awssdk.services.sagemaker.model.AlgorithmValidationProfilesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AlgorithmValidationSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AlgorithmValidationSpecification> {
    private static final SdkField<String> VALIDATION_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AlgorithmValidationSpecification.getter(AlgorithmValidationSpecification::validationRole)).setter(AlgorithmValidationSpecification.setter(Builder::validationRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationRole").build()}).build();
    private static final SdkField<List<AlgorithmValidationProfile>> VALIDATION_PROFILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AlgorithmValidationSpecification.getter(AlgorithmValidationSpecification::validationProfiles)).setter(AlgorithmValidationSpecification.setter(Builder::validationProfiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationProfiles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AlgorithmValidationProfile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALIDATION_ROLE_FIELD, VALIDATION_PROFILES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String validationRole;
    private final List<AlgorithmValidationProfile> validationProfiles;

    private AlgorithmValidationSpecification(BuilderImpl builder) {
        this.validationRole = builder.validationRole;
        this.validationProfiles = builder.validationProfiles;
    }

    public String validationRole() {
        return this.validationRole;
    }

    public List<AlgorithmValidationProfile> validationProfiles() {
        return this.validationProfiles;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.validationRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationProfiles());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlgorithmValidationSpecification)) {
            return false;
        }
        AlgorithmValidationSpecification other = (AlgorithmValidationSpecification)obj;
        return Objects.equals(this.validationRole(), other.validationRole()) && Objects.equals(this.validationProfiles(), other.validationProfiles());
    }

    public String toString() {
        return ToString.builder((String)"AlgorithmValidationSpecification").add("ValidationRole", (Object)this.validationRole()).add("ValidationProfiles", this.validationProfiles()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ValidationRole": {
                return Optional.ofNullable(clazz.cast(this.validationRole()));
            }
            case "ValidationProfiles": {
                return Optional.ofNullable(clazz.cast(this.validationProfiles()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AlgorithmValidationSpecification, T> g) {
        return obj -> g.apply((AlgorithmValidationSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String validationRole;
        private List<AlgorithmValidationProfile> validationProfiles = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AlgorithmValidationSpecification model) {
            this.validationRole(model.validationRole);
            this.validationProfiles(model.validationProfiles);
        }

        public final String getValidationRole() {
            return this.validationRole;
        }

        @Override
        public final Builder validationRole(String validationRole) {
            this.validationRole = validationRole;
            return this;
        }

        public final void setValidationRole(String validationRole) {
            this.validationRole = validationRole;
        }

        public final Collection<AlgorithmValidationProfile.Builder> getValidationProfiles() {
            return this.validationProfiles != null ? (Collection)this.validationProfiles.stream().map(AlgorithmValidationProfile::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder validationProfiles(Collection<AlgorithmValidationProfile> validationProfiles) {
            this.validationProfiles = AlgorithmValidationProfilesCopier.copy(validationProfiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationProfiles(AlgorithmValidationProfile ... validationProfiles) {
            this.validationProfiles(Arrays.asList(validationProfiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationProfiles(Consumer<AlgorithmValidationProfile.Builder> ... validationProfiles) {
            this.validationProfiles(Stream.of(validationProfiles).map(c -> (AlgorithmValidationProfile)((AlgorithmValidationProfile.Builder)AlgorithmValidationProfile.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setValidationProfiles(Collection<AlgorithmValidationProfile.BuilderImpl> validationProfiles) {
            this.validationProfiles = AlgorithmValidationProfilesCopier.copyFromBuilder(validationProfiles);
        }

        public AlgorithmValidationSpecification build() {
            return new AlgorithmValidationSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AlgorithmValidationSpecification> {
        public Builder validationRole(String var1);

        public Builder validationProfiles(Collection<AlgorithmValidationProfile> var1);

        public Builder validationProfiles(AlgorithmValidationProfile ... var1);

        public Builder validationProfiles(Consumer<AlgorithmValidationProfile.Builder> ... var1);
    }
}

