/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WorkforceIpAddressType {
    IPV4("ipv4"),
    DUALSTACK("dualstack"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WorkforceIpAddressType> VALUE_MAP;
    private final String value;

    private WorkforceIpAddressType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WorkforceIpAddressType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WorkforceIpAddressType> knownValues() {
        EnumSet<WorkforceIpAddressType> knownValues = EnumSet.allOf(WorkforceIpAddressType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WorkforceIpAddressType.class, WorkforceIpAddressType::toString);
    }
}

