/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceGroupScalingMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceGroupScalingMetadata> {
    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstanceCount").getter(InstanceGroupScalingMetadata.getter(InstanceGroupScalingMetadata::instanceCount)).setter(InstanceGroupScalingMetadata.setter(Builder::instanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").build()}).build();
    private static final SdkField<Integer> TARGET_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TargetCount").getter(InstanceGroupScalingMetadata.getter(InstanceGroupScalingMetadata::targetCount)).setter(InstanceGroupScalingMetadata.setter(Builder::targetCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetCount").build()}).build();
    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureMessage").getter(InstanceGroupScalingMetadata.getter(InstanceGroupScalingMetadata::failureMessage)).setter(InstanceGroupScalingMetadata.setter(Builder::failureMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_COUNT_FIELD, TARGET_COUNT_FIELD, FAILURE_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InstanceGroupScalingMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer instanceCount;
    private final Integer targetCount;
    private final String failureMessage;

    private InstanceGroupScalingMetadata(BuilderImpl builder) {
        this.instanceCount = builder.instanceCount;
        this.targetCount = builder.targetCount;
        this.failureMessage = builder.failureMessage;
    }

    public final Integer instanceCount() {
        return this.instanceCount;
    }

    public final Integer targetCount() {
        return this.targetCount;
    }

    public final String failureMessage() {
        return this.failureMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceGroupScalingMetadata)) {
            return false;
        }
        InstanceGroupScalingMetadata other = (InstanceGroupScalingMetadata)obj;
        return Objects.equals(this.instanceCount(), other.instanceCount()) && Objects.equals(this.targetCount(), other.targetCount()) && Objects.equals(this.failureMessage(), other.failureMessage());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceGroupScalingMetadata").add("InstanceCount", (Object)this.instanceCount()).add("TargetCount", (Object)this.targetCount()).add("FailureMessage", (Object)this.failureMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceCount": {
                return Optional.ofNullable(clazz.cast(this.instanceCount()));
            }
            case "TargetCount": {
                return Optional.ofNullable(clazz.cast(this.targetCount()));
            }
            case "FailureMessage": {
                return Optional.ofNullable(clazz.cast(this.failureMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceCount", INSTANCE_COUNT_FIELD);
        map.put("TargetCount", TARGET_COUNT_FIELD);
        map.put("FailureMessage", FAILURE_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceGroupScalingMetadata, T> g) {
        return obj -> g.apply((InstanceGroupScalingMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer instanceCount;
        private Integer targetCount;
        private String failureMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceGroupScalingMetadata model) {
            this.instanceCount(model.instanceCount);
            this.targetCount(model.targetCount);
            this.failureMessage(model.failureMessage);
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final Integer getTargetCount() {
            return this.targetCount;
        }

        public final void setTargetCount(Integer targetCount) {
            this.targetCount = targetCount;
        }

        @Override
        public final Builder targetCount(Integer targetCount) {
            this.targetCount = targetCount;
            return this;
        }

        public final String getFailureMessage() {
            return this.failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public InstanceGroupScalingMetadata build() {
            return new InstanceGroupScalingMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceGroupScalingMetadata> {
        public Builder instanceCount(Integer var1);

        public Builder targetCount(Integer var1);

        public Builder failureMessage(String var1);
    }
}

