/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.AppNetworkAccessType;
import software.amazon.awssdk.services.sagemaker.model.AppSecurityGroupManagement;
import software.amazon.awssdk.services.sagemaker.model.AuthMode;
import software.amazon.awssdk.services.sagemaker.model.DefaultSpaceSettings;
import software.amazon.awssdk.services.sagemaker.model.DomainSettings;
import software.amazon.awssdk.services.sagemaker.model.DomainStatus;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.SubnetsCopier;
import software.amazon.awssdk.services.sagemaker.model.TagPropagation;
import software.amazon.awssdk.services.sagemaker.model.UserSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDomainResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeDomainResponse> {
    private static final SdkField<String> DOMAIN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainArn").getter(DescribeDomainResponse.getter(DescribeDomainResponse::domainArn)).setter(DescribeDomainResponse.setter(Builder::domainArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainArn").build()}).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainId").getter(DescribeDomainResponse.getter(DescribeDomainResponse::domainId)).setter(DescribeDomainResponse.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(DescribeDomainResponse.getter(DescribeDomainResponse::domainName)).setter(DescribeDomainResponse.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> HOME_EFS_FILE_SYSTEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HomeEfsFileSystemId").getter(DescribeDomainResponse.getter(DescribeDomainResponse::homeEfsFileSystemId)).setter(DescribeDomainResponse.setter(Builder::homeEfsFileSystemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeEfsFileSystemId").build()}).build();
    private static final SdkField<String> SINGLE_SIGN_ON_MANAGED_APPLICATION_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SingleSignOnManagedApplicationInstanceId").getter(DescribeDomainResponse.getter(DescribeDomainResponse::singleSignOnManagedApplicationInstanceId)).setter(DescribeDomainResponse.setter(Builder::singleSignOnManagedApplicationInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleSignOnManagedApplicationInstanceId").build()}).build();
    private static final SdkField<String> SINGLE_SIGN_ON_APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SingleSignOnApplicationArn").getter(DescribeDomainResponse.getter(DescribeDomainResponse::singleSignOnApplicationArn)).setter(DescribeDomainResponse.setter(Builder::singleSignOnApplicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleSignOnApplicationArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeDomainResponse.getter(DescribeDomainResponse::statusAsString)).setter(DescribeDomainResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeDomainResponse.getter(DescribeDomainResponse::creationTime)).setter(DescribeDomainResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(DescribeDomainResponse.getter(DescribeDomainResponse::lastModifiedTime)).setter(DescribeDomainResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(DescribeDomainResponse.getter(DescribeDomainResponse::failureReason)).setter(DescribeDomainResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<String> SECURITY_GROUP_ID_FOR_DOMAIN_BOUNDARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityGroupIdForDomainBoundary").getter(DescribeDomainResponse.getter(DescribeDomainResponse::securityGroupIdForDomainBoundary)).setter(DescribeDomainResponse.setter(Builder::securityGroupIdForDomainBoundary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIdForDomainBoundary").build()}).build();
    private static final SdkField<String> AUTH_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthMode").getter(DescribeDomainResponse.getter(DescribeDomainResponse::authModeAsString)).setter(DescribeDomainResponse.setter(Builder::authMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthMode").build()}).build();
    private static final SdkField<UserSettings> DEFAULT_USER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultUserSettings").getter(DescribeDomainResponse.getter(DescribeDomainResponse::defaultUserSettings)).setter(DescribeDomainResponse.setter(Builder::defaultUserSettings)).constructor(UserSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultUserSettings").build()}).build();
    private static final SdkField<DomainSettings> DOMAIN_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DomainSettings").getter(DescribeDomainResponse.getter(DescribeDomainResponse::domainSettings)).setter(DescribeDomainResponse.setter(Builder::domainSettings)).constructor(DomainSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainSettings").build()}).build();
    private static final SdkField<String> APP_NETWORK_ACCESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppNetworkAccessType").getter(DescribeDomainResponse.getter(DescribeDomainResponse::appNetworkAccessTypeAsString)).setter(DescribeDomainResponse.setter(Builder::appNetworkAccessType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppNetworkAccessType").build()}).build();
    private static final SdkField<String> HOME_EFS_FILE_SYSTEM_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HomeEfsFileSystemKmsKeyId").getter(DescribeDomainResponse.getter(DescribeDomainResponse::homeEfsFileSystemKmsKeyId)).setter(DescribeDomainResponse.setter(Builder::homeEfsFileSystemKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeEfsFileSystemKmsKeyId").build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetIds").getter(DescribeDomainResponse.getter(DescribeDomainResponse::subnetIds)).setter(DescribeDomainResponse.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Url").getter(DescribeDomainResponse.getter(DescribeDomainResponse::url)).setter(DescribeDomainResponse.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(DescribeDomainResponse.getter(DescribeDomainResponse::vpcId)).setter(DescribeDomainResponse.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(DescribeDomainResponse.getter(DescribeDomainResponse::kmsKeyId)).setter(DescribeDomainResponse.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> APP_SECURITY_GROUP_MANAGEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppSecurityGroupManagement").getter(DescribeDomainResponse.getter(DescribeDomainResponse::appSecurityGroupManagementAsString)).setter(DescribeDomainResponse.setter(Builder::appSecurityGroupManagement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppSecurityGroupManagement").build()}).build();
    private static final SdkField<String> TAG_PROPAGATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TagPropagation").getter(DescribeDomainResponse.getter(DescribeDomainResponse::tagPropagationAsString)).setter(DescribeDomainResponse.setter(Builder::tagPropagation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagPropagation").build()}).build();
    private static final SdkField<DefaultSpaceSettings> DEFAULT_SPACE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultSpaceSettings").getter(DescribeDomainResponse.getter(DescribeDomainResponse::defaultSpaceSettings)).setter(DescribeDomainResponse.setter(Builder::defaultSpaceSettings)).constructor(DefaultSpaceSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultSpaceSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ARN_FIELD, DOMAIN_ID_FIELD, DOMAIN_NAME_FIELD, HOME_EFS_FILE_SYSTEM_ID_FIELD, SINGLE_SIGN_ON_MANAGED_APPLICATION_INSTANCE_ID_FIELD, SINGLE_SIGN_ON_APPLICATION_ARN_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, FAILURE_REASON_FIELD, SECURITY_GROUP_ID_FOR_DOMAIN_BOUNDARY_FIELD, AUTH_MODE_FIELD, DEFAULT_USER_SETTINGS_FIELD, DOMAIN_SETTINGS_FIELD, APP_NETWORK_ACCESS_TYPE_FIELD, HOME_EFS_FILE_SYSTEM_KMS_KEY_ID_FIELD, SUBNET_IDS_FIELD, URL_FIELD, VPC_ID_FIELD, KMS_KEY_ID_FIELD, APP_SECURITY_GROUP_MANAGEMENT_FIELD, TAG_PROPAGATION_FIELD, DEFAULT_SPACE_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeDomainResponse.memberNameToFieldInitializer();
    private final String domainArn;
    private final String domainId;
    private final String domainName;
    private final String homeEfsFileSystemId;
    private final String singleSignOnManagedApplicationInstanceId;
    private final String singleSignOnApplicationArn;
    private final String status;
    private final Instant creationTime;
    private final Instant lastModifiedTime;
    private final String failureReason;
    private final String securityGroupIdForDomainBoundary;
    private final String authMode;
    private final UserSettings defaultUserSettings;
    private final DomainSettings domainSettings;
    private final String appNetworkAccessType;
    private final String homeEfsFileSystemKmsKeyId;
    private final List<String> subnetIds;
    private final String url;
    private final String vpcId;
    private final String kmsKeyId;
    private final String appSecurityGroupManagement;
    private final String tagPropagation;
    private final DefaultSpaceSettings defaultSpaceSettings;

    private DescribeDomainResponse(BuilderImpl builder) {
        super(builder);
        this.domainArn = builder.domainArn;
        this.domainId = builder.domainId;
        this.domainName = builder.domainName;
        this.homeEfsFileSystemId = builder.homeEfsFileSystemId;
        this.singleSignOnManagedApplicationInstanceId = builder.singleSignOnManagedApplicationInstanceId;
        this.singleSignOnApplicationArn = builder.singleSignOnApplicationArn;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.failureReason = builder.failureReason;
        this.securityGroupIdForDomainBoundary = builder.securityGroupIdForDomainBoundary;
        this.authMode = builder.authMode;
        this.defaultUserSettings = builder.defaultUserSettings;
        this.domainSettings = builder.domainSettings;
        this.appNetworkAccessType = builder.appNetworkAccessType;
        this.homeEfsFileSystemKmsKeyId = builder.homeEfsFileSystemKmsKeyId;
        this.subnetIds = builder.subnetIds;
        this.url = builder.url;
        this.vpcId = builder.vpcId;
        this.kmsKeyId = builder.kmsKeyId;
        this.appSecurityGroupManagement = builder.appSecurityGroupManagement;
        this.tagPropagation = builder.tagPropagation;
        this.defaultSpaceSettings = builder.defaultSpaceSettings;
    }

    public final String domainArn() {
        return this.domainArn;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String homeEfsFileSystemId() {
        return this.homeEfsFileSystemId;
    }

    public final String singleSignOnManagedApplicationInstanceId() {
        return this.singleSignOnManagedApplicationInstanceId;
    }

    public final String singleSignOnApplicationArn() {
        return this.singleSignOnApplicationArn;
    }

    public final DomainStatus status() {
        return DomainStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final String securityGroupIdForDomainBoundary() {
        return this.securityGroupIdForDomainBoundary;
    }

    public final AuthMode authMode() {
        return AuthMode.fromValue(this.authMode);
    }

    public final String authModeAsString() {
        return this.authMode;
    }

    public final UserSettings defaultUserSettings() {
        return this.defaultUserSettings;
    }

    public final DomainSettings domainSettings() {
        return this.domainSettings;
    }

    public final AppNetworkAccessType appNetworkAccessType() {
        return AppNetworkAccessType.fromValue(this.appNetworkAccessType);
    }

    public final String appNetworkAccessTypeAsString() {
        return this.appNetworkAccessType;
    }

    @Deprecated
    public final String homeEfsFileSystemKmsKeyId() {
        return this.homeEfsFileSystemKmsKeyId;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public final String url() {
        return this.url;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final AppSecurityGroupManagement appSecurityGroupManagement() {
        return AppSecurityGroupManagement.fromValue(this.appSecurityGroupManagement);
    }

    public final String appSecurityGroupManagementAsString() {
        return this.appSecurityGroupManagement;
    }

    public final TagPropagation tagPropagation() {
        return TagPropagation.fromValue(this.tagPropagation);
    }

    public final String tagPropagationAsString() {
        return this.tagPropagation;
    }

    public final DefaultSpaceSettings defaultSpaceSettings() {
        return this.defaultSpaceSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.homeEfsFileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.singleSignOnManagedApplicationInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.singleSignOnApplicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupIdForDomainBoundary());
        hashCode = 31 * hashCode + Objects.hashCode(this.authModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultUserSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.appNetworkAccessTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.homeEfsFileSystemKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.appSecurityGroupManagementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagPropagationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultSpaceSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDomainResponse)) {
            return false;
        }
        DescribeDomainResponse other = (DescribeDomainResponse)((Object)obj);
        return Objects.equals(this.domainArn(), other.domainArn()) && Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.homeEfsFileSystemId(), other.homeEfsFileSystemId()) && Objects.equals(this.singleSignOnManagedApplicationInstanceId(), other.singleSignOnManagedApplicationInstanceId()) && Objects.equals(this.singleSignOnApplicationArn(), other.singleSignOnApplicationArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.securityGroupIdForDomainBoundary(), other.securityGroupIdForDomainBoundary()) && Objects.equals(this.authModeAsString(), other.authModeAsString()) && Objects.equals(this.defaultUserSettings(), other.defaultUserSettings()) && Objects.equals(this.domainSettings(), other.domainSettings()) && Objects.equals(this.appNetworkAccessTypeAsString(), other.appNetworkAccessTypeAsString()) && Objects.equals(this.homeEfsFileSystemKmsKeyId(), other.homeEfsFileSystemKmsKeyId()) && this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds()) && Objects.equals(this.url(), other.url()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.appSecurityGroupManagementAsString(), other.appSecurityGroupManagementAsString()) && Objects.equals(this.tagPropagationAsString(), other.tagPropagationAsString()) && Objects.equals(this.defaultSpaceSettings(), other.defaultSpaceSettings());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDomainResponse").add("DomainArn", (Object)this.domainArn()).add("DomainId", (Object)this.domainId()).add("DomainName", (Object)this.domainName()).add("HomeEfsFileSystemId", (Object)this.homeEfsFileSystemId()).add("SingleSignOnManagedApplicationInstanceId", (Object)this.singleSignOnManagedApplicationInstanceId()).add("SingleSignOnApplicationArn", (Object)this.singleSignOnApplicationArn()).add("Status", (Object)this.statusAsString()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("FailureReason", (Object)this.failureReason()).add("SecurityGroupIdForDomainBoundary", (Object)this.securityGroupIdForDomainBoundary()).add("AuthMode", (Object)this.authModeAsString()).add("DefaultUserSettings", (Object)this.defaultUserSettings()).add("DomainSettings", (Object)this.domainSettings()).add("AppNetworkAccessType", (Object)this.appNetworkAccessTypeAsString()).add("HomeEfsFileSystemKmsKeyId", (Object)this.homeEfsFileSystemKmsKeyId()).add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).add("Url", (Object)this.url()).add("VpcId", (Object)this.vpcId()).add("KmsKeyId", (Object)this.kmsKeyId()).add("AppSecurityGroupManagement", (Object)this.appSecurityGroupManagementAsString()).add("TagPropagation", (Object)this.tagPropagationAsString()).add("DefaultSpaceSettings", (Object)this.defaultSpaceSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainArn": {
                return Optional.ofNullable(clazz.cast(this.domainArn()));
            }
            case "DomainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "HomeEfsFileSystemId": {
                return Optional.ofNullable(clazz.cast(this.homeEfsFileSystemId()));
            }
            case "SingleSignOnManagedApplicationInstanceId": {
                return Optional.ofNullable(clazz.cast(this.singleSignOnManagedApplicationInstanceId()));
            }
            case "SingleSignOnApplicationArn": {
                return Optional.ofNullable(clazz.cast(this.singleSignOnApplicationArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "SecurityGroupIdForDomainBoundary": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIdForDomainBoundary()));
            }
            case "AuthMode": {
                return Optional.ofNullable(clazz.cast(this.authModeAsString()));
            }
            case "DefaultUserSettings": {
                return Optional.ofNullable(clazz.cast(this.defaultUserSettings()));
            }
            case "DomainSettings": {
                return Optional.ofNullable(clazz.cast(this.domainSettings()));
            }
            case "AppNetworkAccessType": {
                return Optional.ofNullable(clazz.cast(this.appNetworkAccessTypeAsString()));
            }
            case "HomeEfsFileSystemKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.homeEfsFileSystemKmsKeyId()));
            }
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "AppSecurityGroupManagement": {
                return Optional.ofNullable(clazz.cast(this.appSecurityGroupManagementAsString()));
            }
            case "TagPropagation": {
                return Optional.ofNullable(clazz.cast(this.tagPropagationAsString()));
            }
            case "DefaultSpaceSettings": {
                return Optional.ofNullable(clazz.cast(this.defaultSpaceSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DomainArn", DOMAIN_ARN_FIELD);
        map.put("DomainId", DOMAIN_ID_FIELD);
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("HomeEfsFileSystemId", HOME_EFS_FILE_SYSTEM_ID_FIELD);
        map.put("SingleSignOnManagedApplicationInstanceId", SINGLE_SIGN_ON_MANAGED_APPLICATION_INSTANCE_ID_FIELD);
        map.put("SingleSignOnApplicationArn", SINGLE_SIGN_ON_APPLICATION_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        map.put("SecurityGroupIdForDomainBoundary", SECURITY_GROUP_ID_FOR_DOMAIN_BOUNDARY_FIELD);
        map.put("AuthMode", AUTH_MODE_FIELD);
        map.put("DefaultUserSettings", DEFAULT_USER_SETTINGS_FIELD);
        map.put("DomainSettings", DOMAIN_SETTINGS_FIELD);
        map.put("AppNetworkAccessType", APP_NETWORK_ACCESS_TYPE_FIELD);
        map.put("HomeEfsFileSystemKmsKeyId", HOME_EFS_FILE_SYSTEM_KMS_KEY_ID_FIELD);
        map.put("SubnetIds", SUBNET_IDS_FIELD);
        map.put("Url", URL_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("AppSecurityGroupManagement", APP_SECURITY_GROUP_MANAGEMENT_FIELD);
        map.put("TagPropagation", TAG_PROPAGATION_FIELD);
        map.put("DefaultSpaceSettings", DEFAULT_SPACE_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDomainResponse, T> g) {
        return obj -> g.apply((DescribeDomainResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String domainArn;
        private String domainId;
        private String domainName;
        private String homeEfsFileSystemId;
        private String singleSignOnManagedApplicationInstanceId;
        private String singleSignOnApplicationArn;
        private String status;
        private Instant creationTime;
        private Instant lastModifiedTime;
        private String failureReason;
        private String securityGroupIdForDomainBoundary;
        private String authMode;
        private UserSettings defaultUserSettings;
        private DomainSettings domainSettings;
        private String appNetworkAccessType;
        private String homeEfsFileSystemKmsKeyId;
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private String url;
        private String vpcId;
        private String kmsKeyId;
        private String appSecurityGroupManagement;
        private String tagPropagation;
        private DefaultSpaceSettings defaultSpaceSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDomainResponse model) {
            super(model);
            this.domainArn(model.domainArn);
            this.domainId(model.domainId);
            this.domainName(model.domainName);
            this.homeEfsFileSystemId(model.homeEfsFileSystemId);
            this.singleSignOnManagedApplicationInstanceId(model.singleSignOnManagedApplicationInstanceId);
            this.singleSignOnApplicationArn(model.singleSignOnApplicationArn);
            this.status(model.status);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.failureReason(model.failureReason);
            this.securityGroupIdForDomainBoundary(model.securityGroupIdForDomainBoundary);
            this.authMode(model.authMode);
            this.defaultUserSettings(model.defaultUserSettings);
            this.domainSettings(model.domainSettings);
            this.appNetworkAccessType(model.appNetworkAccessType);
            this.homeEfsFileSystemKmsKeyId(model.homeEfsFileSystemKmsKeyId);
            this.subnetIds(model.subnetIds);
            this.url(model.url);
            this.vpcId(model.vpcId);
            this.kmsKeyId(model.kmsKeyId);
            this.appSecurityGroupManagement(model.appSecurityGroupManagement);
            this.tagPropagation(model.tagPropagation);
            this.defaultSpaceSettings(model.defaultSpaceSettings);
        }

        public final String getDomainArn() {
            return this.domainArn;
        }

        public final void setDomainArn(String domainArn) {
            this.domainArn = domainArn;
        }

        @Override
        public final Builder domainArn(String domainArn) {
            this.domainArn = domainArn;
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getHomeEfsFileSystemId() {
            return this.homeEfsFileSystemId;
        }

        public final void setHomeEfsFileSystemId(String homeEfsFileSystemId) {
            this.homeEfsFileSystemId = homeEfsFileSystemId;
        }

        @Override
        public final Builder homeEfsFileSystemId(String homeEfsFileSystemId) {
            this.homeEfsFileSystemId = homeEfsFileSystemId;
            return this;
        }

        public final String getSingleSignOnManagedApplicationInstanceId() {
            return this.singleSignOnManagedApplicationInstanceId;
        }

        public final void setSingleSignOnManagedApplicationInstanceId(String singleSignOnManagedApplicationInstanceId) {
            this.singleSignOnManagedApplicationInstanceId = singleSignOnManagedApplicationInstanceId;
        }

        @Override
        public final Builder singleSignOnManagedApplicationInstanceId(String singleSignOnManagedApplicationInstanceId) {
            this.singleSignOnManagedApplicationInstanceId = singleSignOnManagedApplicationInstanceId;
            return this;
        }

        public final String getSingleSignOnApplicationArn() {
            return this.singleSignOnApplicationArn;
        }

        public final void setSingleSignOnApplicationArn(String singleSignOnApplicationArn) {
            this.singleSignOnApplicationArn = singleSignOnApplicationArn;
        }

        @Override
        public final Builder singleSignOnApplicationArn(String singleSignOnApplicationArn) {
            this.singleSignOnApplicationArn = singleSignOnApplicationArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DomainStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getSecurityGroupIdForDomainBoundary() {
            return this.securityGroupIdForDomainBoundary;
        }

        public final void setSecurityGroupIdForDomainBoundary(String securityGroupIdForDomainBoundary) {
            this.securityGroupIdForDomainBoundary = securityGroupIdForDomainBoundary;
        }

        @Override
        public final Builder securityGroupIdForDomainBoundary(String securityGroupIdForDomainBoundary) {
            this.securityGroupIdForDomainBoundary = securityGroupIdForDomainBoundary;
            return this;
        }

        public final String getAuthMode() {
            return this.authMode;
        }

        public final void setAuthMode(String authMode) {
            this.authMode = authMode;
        }

        @Override
        public final Builder authMode(String authMode) {
            this.authMode = authMode;
            return this;
        }

        @Override
        public final Builder authMode(AuthMode authMode) {
            this.authMode(authMode == null ? null : authMode.toString());
            return this;
        }

        public final UserSettings.Builder getDefaultUserSettings() {
            return this.defaultUserSettings != null ? this.defaultUserSettings.toBuilder() : null;
        }

        public final void setDefaultUserSettings(UserSettings.BuilderImpl defaultUserSettings) {
            this.defaultUserSettings = defaultUserSettings != null ? defaultUserSettings.build() : null;
        }

        @Override
        public final Builder defaultUserSettings(UserSettings defaultUserSettings) {
            this.defaultUserSettings = defaultUserSettings;
            return this;
        }

        public final DomainSettings.Builder getDomainSettings() {
            return this.domainSettings != null ? this.domainSettings.toBuilder() : null;
        }

        public final void setDomainSettings(DomainSettings.BuilderImpl domainSettings) {
            this.domainSettings = domainSettings != null ? domainSettings.build() : null;
        }

        @Override
        public final Builder domainSettings(DomainSettings domainSettings) {
            this.domainSettings = domainSettings;
            return this;
        }

        public final String getAppNetworkAccessType() {
            return this.appNetworkAccessType;
        }

        public final void setAppNetworkAccessType(String appNetworkAccessType) {
            this.appNetworkAccessType = appNetworkAccessType;
        }

        @Override
        public final Builder appNetworkAccessType(String appNetworkAccessType) {
            this.appNetworkAccessType = appNetworkAccessType;
            return this;
        }

        @Override
        public final Builder appNetworkAccessType(AppNetworkAccessType appNetworkAccessType) {
            this.appNetworkAccessType(appNetworkAccessType == null ? null : appNetworkAccessType.toString());
            return this;
        }

        @Deprecated
        public final String getHomeEfsFileSystemKmsKeyId() {
            return this.homeEfsFileSystemKmsKeyId;
        }

        @Deprecated
        public final void setHomeEfsFileSystemKmsKeyId(String homeEfsFileSystemKmsKeyId) {
            this.homeEfsFileSystemKmsKeyId = homeEfsFileSystemKmsKeyId;
        }

        @Override
        @Deprecated
        public final Builder homeEfsFileSystemKmsKeyId(String homeEfsFileSystemKmsKeyId) {
            this.homeEfsFileSystemKmsKeyId = homeEfsFileSystemKmsKeyId;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetsCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getAppSecurityGroupManagement() {
            return this.appSecurityGroupManagement;
        }

        public final void setAppSecurityGroupManagement(String appSecurityGroupManagement) {
            this.appSecurityGroupManagement = appSecurityGroupManagement;
        }

        @Override
        public final Builder appSecurityGroupManagement(String appSecurityGroupManagement) {
            this.appSecurityGroupManagement = appSecurityGroupManagement;
            return this;
        }

        @Override
        public final Builder appSecurityGroupManagement(AppSecurityGroupManagement appSecurityGroupManagement) {
            this.appSecurityGroupManagement(appSecurityGroupManagement == null ? null : appSecurityGroupManagement.toString());
            return this;
        }

        public final String getTagPropagation() {
            return this.tagPropagation;
        }

        public final void setTagPropagation(String tagPropagation) {
            this.tagPropagation = tagPropagation;
        }

        @Override
        public final Builder tagPropagation(String tagPropagation) {
            this.tagPropagation = tagPropagation;
            return this;
        }

        @Override
        public final Builder tagPropagation(TagPropagation tagPropagation) {
            this.tagPropagation(tagPropagation == null ? null : tagPropagation.toString());
            return this;
        }

        public final DefaultSpaceSettings.Builder getDefaultSpaceSettings() {
            return this.defaultSpaceSettings != null ? this.defaultSpaceSettings.toBuilder() : null;
        }

        public final void setDefaultSpaceSettings(DefaultSpaceSettings.BuilderImpl defaultSpaceSettings) {
            this.defaultSpaceSettings = defaultSpaceSettings != null ? defaultSpaceSettings.build() : null;
        }

        @Override
        public final Builder defaultSpaceSettings(DefaultSpaceSettings defaultSpaceSettings) {
            this.defaultSpaceSettings = defaultSpaceSettings;
            return this;
        }

        @Override
        public DescribeDomainResponse build() {
            return new DescribeDomainResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDomainResponse> {
        public Builder domainArn(String var1);

        public Builder domainId(String var1);

        public Builder domainName(String var1);

        public Builder homeEfsFileSystemId(String var1);

        public Builder singleSignOnManagedApplicationInstanceId(String var1);

        public Builder singleSignOnApplicationArn(String var1);

        public Builder status(String var1);

        public Builder status(DomainStatus var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder failureReason(String var1);

        public Builder securityGroupIdForDomainBoundary(String var1);

        public Builder authMode(String var1);

        public Builder authMode(AuthMode var1);

        public Builder defaultUserSettings(UserSettings var1);

        default public Builder defaultUserSettings(Consumer<UserSettings.Builder> defaultUserSettings) {
            return this.defaultUserSettings((UserSettings)((UserSettings.Builder)UserSettings.builder().applyMutation(defaultUserSettings)).build());
        }

        public Builder domainSettings(DomainSettings var1);

        default public Builder domainSettings(Consumer<DomainSettings.Builder> domainSettings) {
            return this.domainSettings((DomainSettings)((DomainSettings.Builder)DomainSettings.builder().applyMutation(domainSettings)).build());
        }

        public Builder appNetworkAccessType(String var1);

        public Builder appNetworkAccessType(AppNetworkAccessType var1);

        @Deprecated
        public Builder homeEfsFileSystemKmsKeyId(String var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder url(String var1);

        public Builder vpcId(String var1);

        public Builder kmsKeyId(String var1);

        public Builder appSecurityGroupManagement(String var1);

        public Builder appSecurityGroupManagement(AppSecurityGroupManagement var1);

        public Builder tagPropagation(String var1);

        public Builder tagPropagation(TagPropagation var1);

        public Builder defaultSpaceSettings(DefaultSpaceSettings var1);

        default public Builder defaultSpaceSettings(Consumer<DefaultSpaceSettings.Builder> defaultSpaceSettings) {
            return this.defaultSpaceSettings((DefaultSpaceSettings)((DefaultSpaceSettings.Builder)DefaultSpaceSettings.builder().applyMutation(defaultSpaceSettings)).build());
        }
    }
}

