/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ClusterAutoScalerType;
import software.amazon.awssdk.services.sagemaker.model.ClusterAutoScalingMode;
import software.amazon.awssdk.services.sagemaker.model.ClusterAutoScalingStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusterAutoScalingConfigOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClusterAutoScalingConfigOutput> {
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mode").getter(ClusterAutoScalingConfigOutput.getter(ClusterAutoScalingConfigOutput::modeAsString)).setter(ClusterAutoScalingConfigOutput.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()}).build();
    private static final SdkField<String> AUTO_SCALER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoScalerType").getter(ClusterAutoScalingConfigOutput.getter(ClusterAutoScalingConfigOutput::autoScalerTypeAsString)).setter(ClusterAutoScalingConfigOutput.setter(Builder::autoScalerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalerType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ClusterAutoScalingConfigOutput.getter(ClusterAutoScalingConfigOutput::statusAsString)).setter(ClusterAutoScalingConfigOutput.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureMessage").getter(ClusterAutoScalingConfigOutput.getter(ClusterAutoScalingConfigOutput::failureMessage)).setter(ClusterAutoScalingConfigOutput.setter(Builder::failureMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODE_FIELD, AUTO_SCALER_TYPE_FIELD, STATUS_FIELD, FAILURE_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ClusterAutoScalingConfigOutput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String mode;
    private final String autoScalerType;
    private final String status;
    private final String failureMessage;

    private ClusterAutoScalingConfigOutput(BuilderImpl builder) {
        this.mode = builder.mode;
        this.autoScalerType = builder.autoScalerType;
        this.status = builder.status;
        this.failureMessage = builder.failureMessage;
    }

    public final ClusterAutoScalingMode mode() {
        return ClusterAutoScalingMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public final ClusterAutoScalerType autoScalerType() {
        return ClusterAutoScalerType.fromValue(this.autoScalerType);
    }

    public final String autoScalerTypeAsString() {
        return this.autoScalerType;
    }

    public final ClusterAutoScalingStatus status() {
        return ClusterAutoScalingStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String failureMessage() {
        return this.failureMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterAutoScalingConfigOutput)) {
            return false;
        }
        ClusterAutoScalingConfigOutput other = (ClusterAutoScalingConfigOutput)obj;
        return Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.autoScalerTypeAsString(), other.autoScalerTypeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.failureMessage(), other.failureMessage());
    }

    public final String toString() {
        return ToString.builder((String)"ClusterAutoScalingConfigOutput").add("Mode", (Object)this.modeAsString()).add("AutoScalerType", (Object)this.autoScalerTypeAsString()).add("Status", (Object)this.statusAsString()).add("FailureMessage", (Object)this.failureMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "AutoScalerType": {
                return Optional.ofNullable(clazz.cast(this.autoScalerTypeAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "FailureMessage": {
                return Optional.ofNullable(clazz.cast(this.failureMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Mode", MODE_FIELD);
        map.put("AutoScalerType", AUTO_SCALER_TYPE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("FailureMessage", FAILURE_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClusterAutoScalingConfigOutput, T> g) {
        return obj -> g.apply((ClusterAutoScalingConfigOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mode;
        private String autoScalerType;
        private String status;
        private String failureMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterAutoScalingConfigOutput model) {
            this.mode(model.mode);
            this.autoScalerType(model.autoScalerType);
            this.status(model.status);
            this.failureMessage(model.failureMessage);
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(ClusterAutoScalingMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final String getAutoScalerType() {
            return this.autoScalerType;
        }

        public final void setAutoScalerType(String autoScalerType) {
            this.autoScalerType = autoScalerType;
        }

        @Override
        public final Builder autoScalerType(String autoScalerType) {
            this.autoScalerType = autoScalerType;
            return this;
        }

        @Override
        public final Builder autoScalerType(ClusterAutoScalerType autoScalerType) {
            this.autoScalerType(autoScalerType == null ? null : autoScalerType.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ClusterAutoScalingStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFailureMessage() {
            return this.failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public ClusterAutoScalingConfigOutput build() {
            return new ClusterAutoScalingConfigOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClusterAutoScalingConfigOutput> {
        public Builder mode(String var1);

        public Builder mode(ClusterAutoScalingMode var1);

        public Builder autoScalerType(String var1);

        public Builder autoScalerType(ClusterAutoScalerType var1);

        public Builder status(String var1);

        public Builder status(ClusterAutoScalingStatus var1);

        public Builder failureMessage(String var1);
    }
}

