/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ProjectStatus;
import software.amazon.awssdk.services.sagemaker.model.ServiceCatalogProvisionedProductDetails;
import software.amazon.awssdk.services.sagemaker.model.ServiceCatalogProvisioningDetails;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.services.sagemaker.model.UserContext;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Project
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Project> {
    private static final SdkField<String> PROJECT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProjectArn").getter(Project.getter(Project::projectArn)).setter(Project.setter(Builder::projectArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectArn").build()}).build();
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProjectName").getter(Project.getter(Project::projectName)).setter(Project.setter(Builder::projectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectName").build()}).build();
    private static final SdkField<String> PROJECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProjectId").getter(Project.getter(Project::projectId)).setter(Project.setter(Builder::projectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectId").build()}).build();
    private static final SdkField<String> PROJECT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProjectDescription").getter(Project.getter(Project::projectDescription)).setter(Project.setter(Builder::projectDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectDescription").build()}).build();
    private static final SdkField<ServiceCatalogProvisioningDetails> SERVICE_CATALOG_PROVISIONING_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ServiceCatalogProvisioningDetails").getter(Project.getter(Project::serviceCatalogProvisioningDetails)).setter(Project.setter(Builder::serviceCatalogProvisioningDetails)).constructor(ServiceCatalogProvisioningDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceCatalogProvisioningDetails").build()}).build();
    private static final SdkField<ServiceCatalogProvisionedProductDetails> SERVICE_CATALOG_PROVISIONED_PRODUCT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ServiceCatalogProvisionedProductDetails").getter(Project.getter(Project::serviceCatalogProvisionedProductDetails)).setter(Project.setter(Builder::serviceCatalogProvisionedProductDetails)).constructor(ServiceCatalogProvisionedProductDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceCatalogProvisionedProductDetails").build()}).build();
    private static final SdkField<String> PROJECT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProjectStatus").getter(Project.getter(Project::projectStatusAsString)).setter(Project.setter(Builder::projectStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectStatus").build()}).build();
    private static final SdkField<UserContext> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreatedBy").getter(Project.getter(Project::createdBy)).setter(Project.setter(Builder::createdBy)).constructor(UserContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(Project.getter(Project::creationTime)).setter(Project.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(Project.getter(Project::tags)).setter(Project.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(Project.getter(Project::lastModifiedTime)).setter(Project.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<UserContext> LAST_MODIFIED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LastModifiedBy").getter(Project.getter(Project::lastModifiedBy)).setter(Project.setter(Builder::lastModifiedBy)).constructor(UserContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ARN_FIELD, PROJECT_NAME_FIELD, PROJECT_ID_FIELD, PROJECT_DESCRIPTION_FIELD, SERVICE_CATALOG_PROVISIONING_DETAILS_FIELD, SERVICE_CATALOG_PROVISIONED_PRODUCT_DETAILS_FIELD, PROJECT_STATUS_FIELD, CREATED_BY_FIELD, CREATION_TIME_FIELD, TAGS_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_BY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Project.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String projectArn;
    private final String projectName;
    private final String projectId;
    private final String projectDescription;
    private final ServiceCatalogProvisioningDetails serviceCatalogProvisioningDetails;
    private final ServiceCatalogProvisionedProductDetails serviceCatalogProvisionedProductDetails;
    private final String projectStatus;
    private final UserContext createdBy;
    private final Instant creationTime;
    private final List<Tag> tags;
    private final Instant lastModifiedTime;
    private final UserContext lastModifiedBy;

    private Project(BuilderImpl builder) {
        this.projectArn = builder.projectArn;
        this.projectName = builder.projectName;
        this.projectId = builder.projectId;
        this.projectDescription = builder.projectDescription;
        this.serviceCatalogProvisioningDetails = builder.serviceCatalogProvisioningDetails;
        this.serviceCatalogProvisionedProductDetails = builder.serviceCatalogProvisionedProductDetails;
        this.projectStatus = builder.projectStatus;
        this.createdBy = builder.createdBy;
        this.creationTime = builder.creationTime;
        this.tags = builder.tags;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedBy = builder.lastModifiedBy;
    }

    public final String projectArn() {
        return this.projectArn;
    }

    public final String projectName() {
        return this.projectName;
    }

    public final String projectId() {
        return this.projectId;
    }

    public final String projectDescription() {
        return this.projectDescription;
    }

    public final ServiceCatalogProvisioningDetails serviceCatalogProvisioningDetails() {
        return this.serviceCatalogProvisioningDetails;
    }

    public final ServiceCatalogProvisionedProductDetails serviceCatalogProvisionedProductDetails() {
        return this.serviceCatalogProvisionedProductDetails;
    }

    public final ProjectStatus projectStatus() {
        return ProjectStatus.fromValue(this.projectStatus);
    }

    public final String projectStatusAsString() {
        return this.projectStatus;
    }

    public final UserContext createdBy() {
        return this.createdBy;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final UserContext lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.projectArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceCatalogProvisioningDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceCatalogProvisionedProductDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedBy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Project)) {
            return false;
        }
        Project other = (Project)obj;
        return Objects.equals(this.projectArn(), other.projectArn()) && Objects.equals(this.projectName(), other.projectName()) && Objects.equals(this.projectId(), other.projectId()) && Objects.equals(this.projectDescription(), other.projectDescription()) && Objects.equals(this.serviceCatalogProvisioningDetails(), other.serviceCatalogProvisioningDetails()) && Objects.equals(this.serviceCatalogProvisionedProductDetails(), other.serviceCatalogProvisionedProductDetails()) && Objects.equals(this.projectStatusAsString(), other.projectStatusAsString()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.creationTime(), other.creationTime()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.lastModifiedBy(), other.lastModifiedBy());
    }

    public final String toString() {
        return ToString.builder((String)"Project").add("ProjectArn", (Object)this.projectArn()).add("ProjectName", (Object)this.projectName()).add("ProjectId", (Object)this.projectId()).add("ProjectDescription", (Object)this.projectDescription()).add("ServiceCatalogProvisioningDetails", (Object)this.serviceCatalogProvisioningDetails()).add("ServiceCatalogProvisionedProductDetails", (Object)this.serviceCatalogProvisionedProductDetails()).add("ProjectStatus", (Object)this.projectStatusAsString()).add("CreatedBy", (Object)this.createdBy()).add("CreationTime", (Object)this.creationTime()).add("Tags", this.hasTags() ? this.tags() : null).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("LastModifiedBy", (Object)this.lastModifiedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProjectArn": {
                return Optional.ofNullable(clazz.cast(this.projectArn()));
            }
            case "ProjectName": {
                return Optional.ofNullable(clazz.cast(this.projectName()));
            }
            case "ProjectId": {
                return Optional.ofNullable(clazz.cast(this.projectId()));
            }
            case "ProjectDescription": {
                return Optional.ofNullable(clazz.cast(this.projectDescription()));
            }
            case "ServiceCatalogProvisioningDetails": {
                return Optional.ofNullable(clazz.cast(this.serviceCatalogProvisioningDetails()));
            }
            case "ServiceCatalogProvisionedProductDetails": {
                return Optional.ofNullable(clazz.cast(this.serviceCatalogProvisionedProductDetails()));
            }
            case "ProjectStatus": {
                return Optional.ofNullable(clazz.cast(this.projectStatusAsString()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "LastModifiedBy": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedBy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProjectArn", PROJECT_ARN_FIELD);
        map.put("ProjectName", PROJECT_NAME_FIELD);
        map.put("ProjectId", PROJECT_ID_FIELD);
        map.put("ProjectDescription", PROJECT_DESCRIPTION_FIELD);
        map.put("ServiceCatalogProvisioningDetails", SERVICE_CATALOG_PROVISIONING_DETAILS_FIELD);
        map.put("ServiceCatalogProvisionedProductDetails", SERVICE_CATALOG_PROVISIONED_PRODUCT_DETAILS_FIELD);
        map.put("ProjectStatus", PROJECT_STATUS_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("LastModifiedBy", LAST_MODIFIED_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Project, T> g) {
        return obj -> g.apply((Project)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String projectArn;
        private String projectName;
        private String projectId;
        private String projectDescription;
        private ServiceCatalogProvisioningDetails serviceCatalogProvisioningDetails;
        private ServiceCatalogProvisionedProductDetails serviceCatalogProvisionedProductDetails;
        private String projectStatus;
        private UserContext createdBy;
        private Instant creationTime;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Instant lastModifiedTime;
        private UserContext lastModifiedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(Project model) {
            this.projectArn(model.projectArn);
            this.projectName(model.projectName);
            this.projectId(model.projectId);
            this.projectDescription(model.projectDescription);
            this.serviceCatalogProvisioningDetails(model.serviceCatalogProvisioningDetails);
            this.serviceCatalogProvisionedProductDetails(model.serviceCatalogProvisionedProductDetails);
            this.projectStatus(model.projectStatus);
            this.createdBy(model.createdBy);
            this.creationTime(model.creationTime);
            this.tags(model.tags);
            this.lastModifiedTime(model.lastModifiedTime);
            this.lastModifiedBy(model.lastModifiedBy);
        }

        public final String getProjectArn() {
            return this.projectArn;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final String getProjectName() {
            return this.projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getProjectId() {
            return this.projectId;
        }

        public final void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        @Override
        public final Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public final String getProjectDescription() {
            return this.projectDescription;
        }

        public final void setProjectDescription(String projectDescription) {
            this.projectDescription = projectDescription;
        }

        @Override
        public final Builder projectDescription(String projectDescription) {
            this.projectDescription = projectDescription;
            return this;
        }

        public final ServiceCatalogProvisioningDetails.Builder getServiceCatalogProvisioningDetails() {
            return this.serviceCatalogProvisioningDetails != null ? this.serviceCatalogProvisioningDetails.toBuilder() : null;
        }

        public final void setServiceCatalogProvisioningDetails(ServiceCatalogProvisioningDetails.BuilderImpl serviceCatalogProvisioningDetails) {
            this.serviceCatalogProvisioningDetails = serviceCatalogProvisioningDetails != null ? serviceCatalogProvisioningDetails.build() : null;
        }

        @Override
        public final Builder serviceCatalogProvisioningDetails(ServiceCatalogProvisioningDetails serviceCatalogProvisioningDetails) {
            this.serviceCatalogProvisioningDetails = serviceCatalogProvisioningDetails;
            return this;
        }

        public final ServiceCatalogProvisionedProductDetails.Builder getServiceCatalogProvisionedProductDetails() {
            return this.serviceCatalogProvisionedProductDetails != null ? this.serviceCatalogProvisionedProductDetails.toBuilder() : null;
        }

        public final void setServiceCatalogProvisionedProductDetails(ServiceCatalogProvisionedProductDetails.BuilderImpl serviceCatalogProvisionedProductDetails) {
            this.serviceCatalogProvisionedProductDetails = serviceCatalogProvisionedProductDetails != null ? serviceCatalogProvisionedProductDetails.build() : null;
        }

        @Override
        public final Builder serviceCatalogProvisionedProductDetails(ServiceCatalogProvisionedProductDetails serviceCatalogProvisionedProductDetails) {
            this.serviceCatalogProvisionedProductDetails = serviceCatalogProvisionedProductDetails;
            return this;
        }

        public final String getProjectStatus() {
            return this.projectStatus;
        }

        public final void setProjectStatus(String projectStatus) {
            this.projectStatus = projectStatus;
        }

        @Override
        public final Builder projectStatus(String projectStatus) {
            this.projectStatus = projectStatus;
            return this;
        }

        @Override
        public final Builder projectStatus(ProjectStatus projectStatus) {
            this.projectStatus(projectStatus == null ? null : projectStatus.toString());
            return this;
        }

        public final UserContext.Builder getCreatedBy() {
            return this.createdBy != null ? this.createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(UserContext.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        public final Builder createdBy(UserContext createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final UserContext.Builder getLastModifiedBy() {
            return this.lastModifiedBy != null ? this.lastModifiedBy.toBuilder() : null;
        }

        public final void setLastModifiedBy(UserContext.BuilderImpl lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy != null ? lastModifiedBy.build() : null;
        }

        @Override
        public final Builder lastModifiedBy(UserContext lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public Project build() {
            return new Project(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Project> {
        public Builder projectArn(String var1);

        public Builder projectName(String var1);

        public Builder projectId(String var1);

        public Builder projectDescription(String var1);

        public Builder serviceCatalogProvisioningDetails(ServiceCatalogProvisioningDetails var1);

        default public Builder serviceCatalogProvisioningDetails(Consumer<ServiceCatalogProvisioningDetails.Builder> serviceCatalogProvisioningDetails) {
            return this.serviceCatalogProvisioningDetails((ServiceCatalogProvisioningDetails)((ServiceCatalogProvisioningDetails.Builder)ServiceCatalogProvisioningDetails.builder().applyMutation(serviceCatalogProvisioningDetails)).build());
        }

        public Builder serviceCatalogProvisionedProductDetails(ServiceCatalogProvisionedProductDetails var1);

        default public Builder serviceCatalogProvisionedProductDetails(Consumer<ServiceCatalogProvisionedProductDetails.Builder> serviceCatalogProvisionedProductDetails) {
            return this.serviceCatalogProvisionedProductDetails((ServiceCatalogProvisionedProductDetails)((ServiceCatalogProvisionedProductDetails.Builder)ServiceCatalogProvisionedProductDetails.builder().applyMutation(serviceCatalogProvisionedProductDetails)).build());
        }

        public Builder projectStatus(String var1);

        public Builder projectStatus(ProjectStatus var1);

        public Builder createdBy(UserContext var1);

        default public Builder createdBy(Consumer<UserContext.Builder> createdBy) {
            return this.createdBy((UserContext)((UserContext.Builder)UserContext.builder().applyMutation(createdBy)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder lastModifiedBy(UserContext var1);

        default public Builder lastModifiedBy(Consumer<UserContext.Builder> lastModifiedBy) {
            return this.lastModifiedBy((UserContext)((UserContext.Builder)UserContext.builder().applyMutation(lastModifiedBy)).build());
        }
    }
}

