/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ModelCardStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelPackageModelCard
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelPackageModelCard> {
    private static final SdkField<String> MODEL_CARD_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelCardContent").getter(ModelPackageModelCard.getter(ModelPackageModelCard::modelCardContent)).setter(ModelPackageModelCard.setter(Builder::modelCardContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardContent").build()}).build();
    private static final SdkField<String> MODEL_CARD_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelCardStatus").getter(ModelPackageModelCard.getter(ModelPackageModelCard::modelCardStatusAsString)).setter(ModelPackageModelCard.setter(Builder::modelCardStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_CARD_CONTENT_FIELD, MODEL_CARD_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModelPackageModelCard.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String modelCardContent;
    private final String modelCardStatus;

    private ModelPackageModelCard(BuilderImpl builder) {
        this.modelCardContent = builder.modelCardContent;
        this.modelCardStatus = builder.modelCardStatus;
    }

    public final String modelCardContent() {
        return this.modelCardContent;
    }

    public final ModelCardStatus modelCardStatus() {
        return ModelCardStatus.fromValue(this.modelCardStatus);
    }

    public final String modelCardStatusAsString() {
        return this.modelCardStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelCardContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelCardStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelPackageModelCard)) {
            return false;
        }
        ModelPackageModelCard other = (ModelPackageModelCard)obj;
        return Objects.equals(this.modelCardContent(), other.modelCardContent()) && Objects.equals(this.modelCardStatusAsString(), other.modelCardStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ModelPackageModelCard").add("ModelCardContent", (Object)(this.modelCardContent() == null ? null : "*** Sensitive Data Redacted ***")).add("ModelCardStatus", (Object)this.modelCardStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelCardContent": {
                return Optional.ofNullable(clazz.cast(this.modelCardContent()));
            }
            case "ModelCardStatus": {
                return Optional.ofNullable(clazz.cast(this.modelCardStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ModelCardContent", MODEL_CARD_CONTENT_FIELD);
        map.put("ModelCardStatus", MODEL_CARD_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModelPackageModelCard, T> g) {
        return obj -> g.apply((ModelPackageModelCard)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String modelCardContent;
        private String modelCardStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelPackageModelCard model) {
            this.modelCardContent(model.modelCardContent);
            this.modelCardStatus(model.modelCardStatus);
        }

        public final String getModelCardContent() {
            return this.modelCardContent;
        }

        public final void setModelCardContent(String modelCardContent) {
            this.modelCardContent = modelCardContent;
        }

        @Override
        public final Builder modelCardContent(String modelCardContent) {
            this.modelCardContent = modelCardContent;
            return this;
        }

        public final String getModelCardStatus() {
            return this.modelCardStatus;
        }

        public final void setModelCardStatus(String modelCardStatus) {
            this.modelCardStatus = modelCardStatus;
        }

        @Override
        public final Builder modelCardStatus(String modelCardStatus) {
            this.modelCardStatus = modelCardStatus;
            return this;
        }

        @Override
        public final Builder modelCardStatus(ModelCardStatus modelCardStatus) {
            this.modelCardStatus(modelCardStatus == null ? null : modelCardStatus.toString());
            return this;
        }

        public ModelPackageModelCard build() {
            return new ModelPackageModelCard(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelPackageModelCard> {
        public Builder modelCardContent(String var1);

        public Builder modelCardStatus(String var1);

        public Builder modelCardStatus(ModelCardStatus var1);
    }
}

