/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ModelDataSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceAlgorithm
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SourceAlgorithm> {
    private static final SdkField<String> MODEL_DATA_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelDataUrl").getter(SourceAlgorithm.getter(SourceAlgorithm::modelDataUrl)).setter(SourceAlgorithm.setter(Builder::modelDataUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelDataUrl").build()}).build();
    private static final SdkField<ModelDataSource> MODEL_DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelDataSource").getter(SourceAlgorithm.getter(SourceAlgorithm::modelDataSource)).setter(SourceAlgorithm.setter(Builder::modelDataSource)).constructor(ModelDataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelDataSource").build()}).build();
    private static final SdkField<String> MODEL_DATA_E_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelDataETag").getter(SourceAlgorithm.getter(SourceAlgorithm::modelDataETag)).setter(SourceAlgorithm.setter(Builder::modelDataETag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelDataETag").build()}).build();
    private static final SdkField<String> ALGORITHM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlgorithmName").getter(SourceAlgorithm.getter(SourceAlgorithm::algorithmName)).setter(SourceAlgorithm.setter(Builder::algorithmName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_DATA_URL_FIELD, MODEL_DATA_SOURCE_FIELD, MODEL_DATA_E_TAG_FIELD, ALGORITHM_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SourceAlgorithm.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String modelDataUrl;
    private final ModelDataSource modelDataSource;
    private final String modelDataETag;
    private final String algorithmName;

    private SourceAlgorithm(BuilderImpl builder) {
        this.modelDataUrl = builder.modelDataUrl;
        this.modelDataSource = builder.modelDataSource;
        this.modelDataETag = builder.modelDataETag;
        this.algorithmName = builder.algorithmName;
    }

    public final String modelDataUrl() {
        return this.modelDataUrl;
    }

    public final ModelDataSource modelDataSource() {
        return this.modelDataSource;
    }

    public final String modelDataETag() {
        return this.modelDataETag;
    }

    public final String algorithmName() {
        return this.algorithmName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelDataUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelDataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelDataETag());
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceAlgorithm)) {
            return false;
        }
        SourceAlgorithm other = (SourceAlgorithm)obj;
        return Objects.equals(this.modelDataUrl(), other.modelDataUrl()) && Objects.equals(this.modelDataSource(), other.modelDataSource()) && Objects.equals(this.modelDataETag(), other.modelDataETag()) && Objects.equals(this.algorithmName(), other.algorithmName());
    }

    public final String toString() {
        return ToString.builder((String)"SourceAlgorithm").add("ModelDataUrl", (Object)this.modelDataUrl()).add("ModelDataSource", (Object)this.modelDataSource()).add("ModelDataETag", (Object)this.modelDataETag()).add("AlgorithmName", (Object)this.algorithmName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelDataUrl": {
                return Optional.ofNullable(clazz.cast(this.modelDataUrl()));
            }
            case "ModelDataSource": {
                return Optional.ofNullable(clazz.cast(this.modelDataSource()));
            }
            case "ModelDataETag": {
                return Optional.ofNullable(clazz.cast(this.modelDataETag()));
            }
            case "AlgorithmName": {
                return Optional.ofNullable(clazz.cast(this.algorithmName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ModelDataUrl", MODEL_DATA_URL_FIELD);
        map.put("ModelDataSource", MODEL_DATA_SOURCE_FIELD);
        map.put("ModelDataETag", MODEL_DATA_E_TAG_FIELD);
        map.put("AlgorithmName", ALGORITHM_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SourceAlgorithm, T> g) {
        return obj -> g.apply((SourceAlgorithm)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String modelDataUrl;
        private ModelDataSource modelDataSource;
        private String modelDataETag;
        private String algorithmName;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceAlgorithm model) {
            this.modelDataUrl(model.modelDataUrl);
            this.modelDataSource(model.modelDataSource);
            this.modelDataETag(model.modelDataETag);
            this.algorithmName(model.algorithmName);
        }

        public final String getModelDataUrl() {
            return this.modelDataUrl;
        }

        public final void setModelDataUrl(String modelDataUrl) {
            this.modelDataUrl = modelDataUrl;
        }

        @Override
        public final Builder modelDataUrl(String modelDataUrl) {
            this.modelDataUrl = modelDataUrl;
            return this;
        }

        public final ModelDataSource.Builder getModelDataSource() {
            return this.modelDataSource != null ? this.modelDataSource.toBuilder() : null;
        }

        public final void setModelDataSource(ModelDataSource.BuilderImpl modelDataSource) {
            this.modelDataSource = modelDataSource != null ? modelDataSource.build() : null;
        }

        @Override
        public final Builder modelDataSource(ModelDataSource modelDataSource) {
            this.modelDataSource = modelDataSource;
            return this;
        }

        public final String getModelDataETag() {
            return this.modelDataETag;
        }

        public final void setModelDataETag(String modelDataETag) {
            this.modelDataETag = modelDataETag;
        }

        @Override
        public final Builder modelDataETag(String modelDataETag) {
            this.modelDataETag = modelDataETag;
            return this;
        }

        public final String getAlgorithmName() {
            return this.algorithmName;
        }

        public final void setAlgorithmName(String algorithmName) {
            this.algorithmName = algorithmName;
        }

        @Override
        public final Builder algorithmName(String algorithmName) {
            this.algorithmName = algorithmName;
            return this;
        }

        public SourceAlgorithm build() {
            return new SourceAlgorithm(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SourceAlgorithm> {
        public Builder modelDataUrl(String var1);

        public Builder modelDataSource(ModelDataSource var1);

        default public Builder modelDataSource(Consumer<ModelDataSource.Builder> modelDataSource) {
            return this.modelDataSource((ModelDataSource)((ModelDataSource.Builder)ModelDataSource.builder().applyMutation(modelDataSource)).build());
        }

        public Builder modelDataETag(String var1);

        public Builder algorithmName(String var1);
    }
}

