/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ThroughputMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ThroughputConfigDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ThroughputConfigDescription> {
    private static final SdkField<String> THROUGHPUT_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ThroughputMode").getter(ThroughputConfigDescription.getter(ThroughputConfigDescription::throughputModeAsString)).setter(ThroughputConfigDescription.setter(Builder::throughputMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThroughputMode").build()}).build();
    private static final SdkField<Integer> PROVISIONED_READ_CAPACITY_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ProvisionedReadCapacityUnits").getter(ThroughputConfigDescription.getter(ThroughputConfigDescription::provisionedReadCapacityUnits)).setter(ThroughputConfigDescription.setter(Builder::provisionedReadCapacityUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedReadCapacityUnits").build()}).build();
    private static final SdkField<Integer> PROVISIONED_WRITE_CAPACITY_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ProvisionedWriteCapacityUnits").getter(ThroughputConfigDescription.getter(ThroughputConfigDescription::provisionedWriteCapacityUnits)).setter(ThroughputConfigDescription.setter(Builder::provisionedWriteCapacityUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedWriteCapacityUnits").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THROUGHPUT_MODE_FIELD, PROVISIONED_READ_CAPACITY_UNITS_FIELD, PROVISIONED_WRITE_CAPACITY_UNITS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ThroughputConfigDescription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String throughputMode;
    private final Integer provisionedReadCapacityUnits;
    private final Integer provisionedWriteCapacityUnits;

    private ThroughputConfigDescription(BuilderImpl builder) {
        this.throughputMode = builder.throughputMode;
        this.provisionedReadCapacityUnits = builder.provisionedReadCapacityUnits;
        this.provisionedWriteCapacityUnits = builder.provisionedWriteCapacityUnits;
    }

    public final ThroughputMode throughputMode() {
        return ThroughputMode.fromValue(this.throughputMode);
    }

    public final String throughputModeAsString() {
        return this.throughputMode;
    }

    public final Integer provisionedReadCapacityUnits() {
        return this.provisionedReadCapacityUnits;
    }

    public final Integer provisionedWriteCapacityUnits() {
        return this.provisionedWriteCapacityUnits;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.throughputModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedReadCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedWriteCapacityUnits());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThroughputConfigDescription)) {
            return false;
        }
        ThroughputConfigDescription other = (ThroughputConfigDescription)obj;
        return Objects.equals(this.throughputModeAsString(), other.throughputModeAsString()) && Objects.equals(this.provisionedReadCapacityUnits(), other.provisionedReadCapacityUnits()) && Objects.equals(this.provisionedWriteCapacityUnits(), other.provisionedWriteCapacityUnits());
    }

    public final String toString() {
        return ToString.builder((String)"ThroughputConfigDescription").add("ThroughputMode", (Object)this.throughputModeAsString()).add("ProvisionedReadCapacityUnits", (Object)this.provisionedReadCapacityUnits()).add("ProvisionedWriteCapacityUnits", (Object)this.provisionedWriteCapacityUnits()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ThroughputMode": {
                return Optional.ofNullable(clazz.cast(this.throughputModeAsString()));
            }
            case "ProvisionedReadCapacityUnits": {
                return Optional.ofNullable(clazz.cast(this.provisionedReadCapacityUnits()));
            }
            case "ProvisionedWriteCapacityUnits": {
                return Optional.ofNullable(clazz.cast(this.provisionedWriteCapacityUnits()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ThroughputMode", THROUGHPUT_MODE_FIELD);
        map.put("ProvisionedReadCapacityUnits", PROVISIONED_READ_CAPACITY_UNITS_FIELD);
        map.put("ProvisionedWriteCapacityUnits", PROVISIONED_WRITE_CAPACITY_UNITS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ThroughputConfigDescription, T> g) {
        return obj -> g.apply((ThroughputConfigDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String throughputMode;
        private Integer provisionedReadCapacityUnits;
        private Integer provisionedWriteCapacityUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(ThroughputConfigDescription model) {
            this.throughputMode(model.throughputMode);
            this.provisionedReadCapacityUnits(model.provisionedReadCapacityUnits);
            this.provisionedWriteCapacityUnits(model.provisionedWriteCapacityUnits);
        }

        public final String getThroughputMode() {
            return this.throughputMode;
        }

        public final void setThroughputMode(String throughputMode) {
            this.throughputMode = throughputMode;
        }

        @Override
        public final Builder throughputMode(String throughputMode) {
            this.throughputMode = throughputMode;
            return this;
        }

        @Override
        public final Builder throughputMode(ThroughputMode throughputMode) {
            this.throughputMode(throughputMode == null ? null : throughputMode.toString());
            return this;
        }

        public final Integer getProvisionedReadCapacityUnits() {
            return this.provisionedReadCapacityUnits;
        }

        public final void setProvisionedReadCapacityUnits(Integer provisionedReadCapacityUnits) {
            this.provisionedReadCapacityUnits = provisionedReadCapacityUnits;
        }

        @Override
        public final Builder provisionedReadCapacityUnits(Integer provisionedReadCapacityUnits) {
            this.provisionedReadCapacityUnits = provisionedReadCapacityUnits;
            return this;
        }

        public final Integer getProvisionedWriteCapacityUnits() {
            return this.provisionedWriteCapacityUnits;
        }

        public final void setProvisionedWriteCapacityUnits(Integer provisionedWriteCapacityUnits) {
            this.provisionedWriteCapacityUnits = provisionedWriteCapacityUnits;
        }

        @Override
        public final Builder provisionedWriteCapacityUnits(Integer provisionedWriteCapacityUnits) {
            this.provisionedWriteCapacityUnits = provisionedWriteCapacityUnits;
            return this;
        }

        public ThroughputConfigDescription build() {
            return new ThroughputConfigDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ThroughputConfigDescription> {
        public Builder throughputMode(String var1);

        public Builder throughputMode(ThroughputMode var1);

        public Builder provisionedReadCapacityUnits(Integer var1);

        public Builder provisionedWriteCapacityUnits(Integer var1);
    }
}

