/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.EdgePresetDeploymentType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EdgeOutputConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EdgeOutputConfig> {
    private static final SdkField<String> S3_OUTPUT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3OutputLocation").getter(EdgeOutputConfig.getter(EdgeOutputConfig::s3OutputLocation)).setter(EdgeOutputConfig.setter(Builder::s3OutputLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3OutputLocation").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(EdgeOutputConfig.getter(EdgeOutputConfig::kmsKeyId)).setter(EdgeOutputConfig.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> PRESET_DEPLOYMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PresetDeploymentType").getter(EdgeOutputConfig.getter(EdgeOutputConfig::presetDeploymentTypeAsString)).setter(EdgeOutputConfig.setter(Builder::presetDeploymentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PresetDeploymentType").build()}).build();
    private static final SdkField<String> PRESET_DEPLOYMENT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PresetDeploymentConfig").getter(EdgeOutputConfig.getter(EdgeOutputConfig::presetDeploymentConfig)).setter(EdgeOutputConfig.setter(Builder::presetDeploymentConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PresetDeploymentConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_OUTPUT_LOCATION_FIELD, KMS_KEY_ID_FIELD, PRESET_DEPLOYMENT_TYPE_FIELD, PRESET_DEPLOYMENT_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EdgeOutputConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String s3OutputLocation;
    private final String kmsKeyId;
    private final String presetDeploymentType;
    private final String presetDeploymentConfig;

    private EdgeOutputConfig(BuilderImpl builder) {
        this.s3OutputLocation = builder.s3OutputLocation;
        this.kmsKeyId = builder.kmsKeyId;
        this.presetDeploymentType = builder.presetDeploymentType;
        this.presetDeploymentConfig = builder.presetDeploymentConfig;
    }

    public final String s3OutputLocation() {
        return this.s3OutputLocation;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final EdgePresetDeploymentType presetDeploymentType() {
        return EdgePresetDeploymentType.fromValue(this.presetDeploymentType);
    }

    public final String presetDeploymentTypeAsString() {
        return this.presetDeploymentType;
    }

    public final String presetDeploymentConfig() {
        return this.presetDeploymentConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3OutputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.presetDeploymentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.presetDeploymentConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EdgeOutputConfig)) {
            return false;
        }
        EdgeOutputConfig other = (EdgeOutputConfig)obj;
        return Objects.equals(this.s3OutputLocation(), other.s3OutputLocation()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.presetDeploymentTypeAsString(), other.presetDeploymentTypeAsString()) && Objects.equals(this.presetDeploymentConfig(), other.presetDeploymentConfig());
    }

    public final String toString() {
        return ToString.builder((String)"EdgeOutputConfig").add("S3OutputLocation", (Object)this.s3OutputLocation()).add("KmsKeyId", (Object)this.kmsKeyId()).add("PresetDeploymentType", (Object)this.presetDeploymentTypeAsString()).add("PresetDeploymentConfig", (Object)this.presetDeploymentConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3OutputLocation": {
                return Optional.ofNullable(clazz.cast(this.s3OutputLocation()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "PresetDeploymentType": {
                return Optional.ofNullable(clazz.cast(this.presetDeploymentTypeAsString()));
            }
            case "PresetDeploymentConfig": {
                return Optional.ofNullable(clazz.cast(this.presetDeploymentConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("S3OutputLocation", S3_OUTPUT_LOCATION_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("PresetDeploymentType", PRESET_DEPLOYMENT_TYPE_FIELD);
        map.put("PresetDeploymentConfig", PRESET_DEPLOYMENT_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EdgeOutputConfig, T> g) {
        return obj -> g.apply((EdgeOutputConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3OutputLocation;
        private String kmsKeyId;
        private String presetDeploymentType;
        private String presetDeploymentConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(EdgeOutputConfig model) {
            this.s3OutputLocation(model.s3OutputLocation);
            this.kmsKeyId(model.kmsKeyId);
            this.presetDeploymentType(model.presetDeploymentType);
            this.presetDeploymentConfig(model.presetDeploymentConfig);
        }

        public final String getS3OutputLocation() {
            return this.s3OutputLocation;
        }

        public final void setS3OutputLocation(String s3OutputLocation) {
            this.s3OutputLocation = s3OutputLocation;
        }

        @Override
        public final Builder s3OutputLocation(String s3OutputLocation) {
            this.s3OutputLocation = s3OutputLocation;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getPresetDeploymentType() {
            return this.presetDeploymentType;
        }

        public final void setPresetDeploymentType(String presetDeploymentType) {
            this.presetDeploymentType = presetDeploymentType;
        }

        @Override
        public final Builder presetDeploymentType(String presetDeploymentType) {
            this.presetDeploymentType = presetDeploymentType;
            return this;
        }

        @Override
        public final Builder presetDeploymentType(EdgePresetDeploymentType presetDeploymentType) {
            this.presetDeploymentType(presetDeploymentType == null ? null : presetDeploymentType.toString());
            return this;
        }

        public final String getPresetDeploymentConfig() {
            return this.presetDeploymentConfig;
        }

        public final void setPresetDeploymentConfig(String presetDeploymentConfig) {
            this.presetDeploymentConfig = presetDeploymentConfig;
        }

        @Override
        public final Builder presetDeploymentConfig(String presetDeploymentConfig) {
            this.presetDeploymentConfig = presetDeploymentConfig;
            return this;
        }

        public EdgeOutputConfig build() {
            return new EdgeOutputConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EdgeOutputConfig> {
        public Builder s3OutputLocation(String var1);

        public Builder kmsKeyId(String var1);

        public Builder presetDeploymentType(String var1);

        public Builder presetDeploymentType(EdgePresetDeploymentType var1);

        public Builder presetDeploymentConfig(String var1);
    }
}

