/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.Relation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TotalHits
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TotalHits> {
    private static final SdkField<Long> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Value").getter(TotalHits.getter(TotalHits::value)).setter(TotalHits.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<String> RELATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Relation").getter(TotalHits.getter(TotalHits::relationAsString)).setter(TotalHits.setter(Builder::relation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Relation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, RELATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TotalHits.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long value;
    private final String relation;

    private TotalHits(BuilderImpl builder) {
        this.value = builder.value;
        this.relation = builder.relation;
    }

    public final Long value() {
        return this.value;
    }

    public final Relation relation() {
        return Relation.fromValue(this.relation);
    }

    public final String relationAsString() {
        return this.relation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.relationAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TotalHits)) {
            return false;
        }
        TotalHits other = (TotalHits)obj;
        return Objects.equals(this.value(), other.value()) && Objects.equals(this.relationAsString(), other.relationAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TotalHits").add("Value", (Object)this.value()).add("Relation", (Object)this.relationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "Relation": {
                return Optional.ofNullable(clazz.cast(this.relationAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Value", VALUE_FIELD);
        map.put("Relation", RELATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TotalHits, T> g) {
        return obj -> g.apply((TotalHits)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long value;
        private String relation;

        private BuilderImpl() {
        }

        private BuilderImpl(TotalHits model) {
            this.value(model.value);
            this.relation(model.relation);
        }

        public final Long getValue() {
            return this.value;
        }

        public final void setValue(Long value) {
            this.value = value;
        }

        @Override
        public final Builder value(Long value) {
            this.value = value;
            return this;
        }

        public final String getRelation() {
            return this.relation;
        }

        public final void setRelation(String relation) {
            this.relation = relation;
        }

        @Override
        public final Builder relation(String relation) {
            this.relation = relation;
            return this;
        }

        @Override
        public final Builder relation(Relation relation) {
            this.relation(relation == null ? null : relation.toString());
            return this;
        }

        public TotalHits build() {
            return new TotalHits(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TotalHits> {
        public Builder value(Long var1);

        public Builder relation(String var1);

        public Builder relation(Relation var1);
    }
}

