/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ClusterInstanceStatusDetails;
import software.amazon.awssdk.services.sagemaker.model.ClusterInstanceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusterNodeSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClusterNodeSummary> {
    private static final SdkField<String> INSTANCE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceGroupName").getter(ClusterNodeSummary.getter(ClusterNodeSummary::instanceGroupName)).setter(ClusterNodeSummary.setter(Builder::instanceGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroupName").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(ClusterNodeSummary.getter(ClusterNodeSummary::instanceId)).setter(ClusterNodeSummary.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(ClusterNodeSummary.getter(ClusterNodeSummary::instanceTypeAsString)).setter(ClusterNodeSummary.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<Instant> LAUNCH_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LaunchTime").getter(ClusterNodeSummary.getter(ClusterNodeSummary::launchTime)).setter(ClusterNodeSummary.setter(Builder::launchTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTime").build()}).build();
    private static final SdkField<Instant> LAST_SOFTWARE_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastSoftwareUpdateTime").getter(ClusterNodeSummary.getter(ClusterNodeSummary::lastSoftwareUpdateTime)).setter(ClusterNodeSummary.setter(Builder::lastSoftwareUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSoftwareUpdateTime").build()}).build();
    private static final SdkField<ClusterInstanceStatusDetails> INSTANCE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceStatus").getter(ClusterNodeSummary.getter(ClusterNodeSummary::instanceStatus)).setter(ClusterNodeSummary.setter(Builder::instanceStatus)).constructor(ClusterInstanceStatusDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_GROUP_NAME_FIELD, INSTANCE_ID_FIELD, INSTANCE_TYPE_FIELD, LAUNCH_TIME_FIELD, LAST_SOFTWARE_UPDATE_TIME_FIELD, INSTANCE_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ClusterNodeSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String instanceGroupName;
    private final String instanceId;
    private final String instanceType;
    private final Instant launchTime;
    private final Instant lastSoftwareUpdateTime;
    private final ClusterInstanceStatusDetails instanceStatus;

    private ClusterNodeSummary(BuilderImpl builder) {
        this.instanceGroupName = builder.instanceGroupName;
        this.instanceId = builder.instanceId;
        this.instanceType = builder.instanceType;
        this.launchTime = builder.launchTime;
        this.lastSoftwareUpdateTime = builder.lastSoftwareUpdateTime;
        this.instanceStatus = builder.instanceStatus;
    }

    public final String instanceGroupName() {
        return this.instanceGroupName;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final ClusterInstanceType instanceType() {
        return ClusterInstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final Instant launchTime() {
        return this.launchTime;
    }

    public final Instant lastSoftwareUpdateTime() {
        return this.lastSoftwareUpdateTime;
    }

    public final ClusterInstanceStatusDetails instanceStatus() {
        return this.instanceStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSoftwareUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceStatus());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterNodeSummary)) {
            return false;
        }
        ClusterNodeSummary other = (ClusterNodeSummary)obj;
        return Objects.equals(this.instanceGroupName(), other.instanceGroupName()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.launchTime(), other.launchTime()) && Objects.equals(this.lastSoftwareUpdateTime(), other.lastSoftwareUpdateTime()) && Objects.equals(this.instanceStatus(), other.instanceStatus());
    }

    public final String toString() {
        return ToString.builder((String)"ClusterNodeSummary").add("InstanceGroupName", (Object)this.instanceGroupName()).add("InstanceId", (Object)this.instanceId()).add("InstanceType", (Object)this.instanceTypeAsString()).add("LaunchTime", (Object)this.launchTime()).add("LastSoftwareUpdateTime", (Object)this.lastSoftwareUpdateTime()).add("InstanceStatus", (Object)this.instanceStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceGroupName": {
                return Optional.ofNullable(clazz.cast(this.instanceGroupName()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "LaunchTime": {
                return Optional.ofNullable(clazz.cast(this.launchTime()));
            }
            case "LastSoftwareUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastSoftwareUpdateTime()));
            }
            case "InstanceStatus": {
                return Optional.ofNullable(clazz.cast(this.instanceStatus()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceGroupName", INSTANCE_GROUP_NAME_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("LaunchTime", LAUNCH_TIME_FIELD);
        map.put("LastSoftwareUpdateTime", LAST_SOFTWARE_UPDATE_TIME_FIELD);
        map.put("InstanceStatus", INSTANCE_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClusterNodeSummary, T> g) {
        return obj -> g.apply((ClusterNodeSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceGroupName;
        private String instanceId;
        private String instanceType;
        private Instant launchTime;
        private Instant lastSoftwareUpdateTime;
        private ClusterInstanceStatusDetails instanceStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterNodeSummary model) {
            this.instanceGroupName(model.instanceGroupName);
            this.instanceId(model.instanceId);
            this.instanceType(model.instanceType);
            this.launchTime(model.launchTime);
            this.lastSoftwareUpdateTime(model.lastSoftwareUpdateTime);
            this.instanceStatus(model.instanceStatus);
        }

        public final String getInstanceGroupName() {
            return this.instanceGroupName;
        }

        public final void setInstanceGroupName(String instanceGroupName) {
            this.instanceGroupName = instanceGroupName;
        }

        @Override
        public final Builder instanceGroupName(String instanceGroupName) {
            this.instanceGroupName = instanceGroupName;
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(ClusterInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final Instant getLaunchTime() {
            return this.launchTime;
        }

        public final void setLaunchTime(Instant launchTime) {
            this.launchTime = launchTime;
        }

        @Override
        public final Builder launchTime(Instant launchTime) {
            this.launchTime = launchTime;
            return this;
        }

        public final Instant getLastSoftwareUpdateTime() {
            return this.lastSoftwareUpdateTime;
        }

        public final void setLastSoftwareUpdateTime(Instant lastSoftwareUpdateTime) {
            this.lastSoftwareUpdateTime = lastSoftwareUpdateTime;
        }

        @Override
        public final Builder lastSoftwareUpdateTime(Instant lastSoftwareUpdateTime) {
            this.lastSoftwareUpdateTime = lastSoftwareUpdateTime;
            return this;
        }

        public final ClusterInstanceStatusDetails.Builder getInstanceStatus() {
            return this.instanceStatus != null ? this.instanceStatus.toBuilder() : null;
        }

        public final void setInstanceStatus(ClusterInstanceStatusDetails.BuilderImpl instanceStatus) {
            this.instanceStatus = instanceStatus != null ? instanceStatus.build() : null;
        }

        @Override
        public final Builder instanceStatus(ClusterInstanceStatusDetails instanceStatus) {
            this.instanceStatus = instanceStatus;
            return this;
        }

        public ClusterNodeSummary build() {
            return new ClusterNodeSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClusterNodeSummary> {
        public Builder instanceGroupName(String var1);

        public Builder instanceId(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(ClusterInstanceType var1);

        public Builder launchTime(Instant var1);

        public Builder lastSoftwareUpdateTime(Instant var1);

        public Builder instanceStatus(ClusterInstanceStatusDetails var1);

        default public Builder instanceStatus(Consumer<ClusterInstanceStatusDetails.Builder> instanceStatus) {
            return this.instanceStatus((ClusterInstanceStatusDetails)((ClusterInstanceStatusDetails.Builder)ClusterInstanceStatusDetails.builder().applyMutation(instanceStatus)).build());
        }
    }
}

