/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.CollectionParametersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CollectionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CollectionConfiguration> {
    private static final SdkField<String> COLLECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CollectionName").getter(CollectionConfiguration.getter(CollectionConfiguration::collectionName)).setter(CollectionConfiguration.setter(Builder::collectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionName").build()}).build();
    private static final SdkField<Map<String, String>> COLLECTION_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("CollectionParameters").getter(CollectionConfiguration.getter(CollectionConfiguration::collectionParameters)).setter(CollectionConfiguration.setter(Builder::collectionParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_NAME_FIELD, COLLECTION_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CollectionConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String collectionName;
    private final Map<String, String> collectionParameters;

    private CollectionConfiguration(BuilderImpl builder) {
        this.collectionName = builder.collectionName;
        this.collectionParameters = builder.collectionParameters;
    }

    public final String collectionName() {
        return this.collectionName;
    }

    public final boolean hasCollectionParameters() {
        return this.collectionParameters != null && !(this.collectionParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> collectionParameters() {
        return this.collectionParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCollectionParameters() ? this.collectionParameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CollectionConfiguration)) {
            return false;
        }
        CollectionConfiguration other = (CollectionConfiguration)obj;
        return Objects.equals(this.collectionName(), other.collectionName()) && this.hasCollectionParameters() == other.hasCollectionParameters() && Objects.equals(this.collectionParameters(), other.collectionParameters());
    }

    public final String toString() {
        return ToString.builder((String)"CollectionConfiguration").add("CollectionName", (Object)this.collectionName()).add("CollectionParameters", this.hasCollectionParameters() ? this.collectionParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CollectionName": {
                return Optional.ofNullable(clazz.cast(this.collectionName()));
            }
            case "CollectionParameters": {
                return Optional.ofNullable(clazz.cast(this.collectionParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CollectionName", COLLECTION_NAME_FIELD);
        map.put("CollectionParameters", COLLECTION_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CollectionConfiguration, T> g) {
        return obj -> g.apply((CollectionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String collectionName;
        private Map<String, String> collectionParameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CollectionConfiguration model) {
            this.collectionName(model.collectionName);
            this.collectionParameters(model.collectionParameters);
        }

        public final String getCollectionName() {
            return this.collectionName;
        }

        public final void setCollectionName(String collectionName) {
            this.collectionName = collectionName;
        }

        @Override
        public final Builder collectionName(String collectionName) {
            this.collectionName = collectionName;
            return this;
        }

        public final Map<String, String> getCollectionParameters() {
            if (this.collectionParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.collectionParameters;
        }

        public final void setCollectionParameters(Map<String, String> collectionParameters) {
            this.collectionParameters = CollectionParametersCopier.copy(collectionParameters);
        }

        @Override
        public final Builder collectionParameters(Map<String, String> collectionParameters) {
            this.collectionParameters = CollectionParametersCopier.copy(collectionParameters);
            return this;
        }

        public CollectionConfiguration build() {
            return new CollectionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CollectionConfiguration> {
        public Builder collectionName(String var1);

        public Builder collectionParameters(Map<String, String> var1);
    }
}

