/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ContainerDefinition;
import software.amazon.awssdk.services.sagemaker.model.ContainerDefinitionListCopier;
import software.amazon.awssdk.services.sagemaker.model.DeploymentRecommendation;
import software.amazon.awssdk.services.sagemaker.model.InferenceExecutionConfig;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.VpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeModelResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeModelResponse> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelName").getter(DescribeModelResponse.getter(DescribeModelResponse::modelName)).setter(DescribeModelResponse.setter(Builder::modelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()}).build();
    private static final SdkField<ContainerDefinition> PRIMARY_CONTAINER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PrimaryContainer").getter(DescribeModelResponse.getter(DescribeModelResponse::primaryContainer)).setter(DescribeModelResponse.setter(Builder::primaryContainer)).constructor(ContainerDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryContainer").build()}).build();
    private static final SdkField<List<ContainerDefinition>> CONTAINERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Containers").getter(DescribeModelResponse.getter(DescribeModelResponse::containers)).setter(DescribeModelResponse.setter(Builder::containers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Containers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContainerDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<InferenceExecutionConfig> INFERENCE_EXECUTION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InferenceExecutionConfig").getter(DescribeModelResponse.getter(DescribeModelResponse::inferenceExecutionConfig)).setter(DescribeModelResponse.setter(Builder::inferenceExecutionConfig)).constructor(InferenceExecutionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceExecutionConfig").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRoleArn").getter(DescribeModelResponse.getter(DescribeModelResponse::executionRoleArn)).setter(DescribeModelResponse.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()}).build();
    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfig").getter(DescribeModelResponse.getter(DescribeModelResponse::vpcConfig)).setter(DescribeModelResponse.setter(Builder::vpcConfig)).constructor(VpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeModelResponse.getter(DescribeModelResponse::creationTime)).setter(DescribeModelResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelArn").getter(DescribeModelResponse.getter(DescribeModelResponse::modelArn)).setter(DescribeModelResponse.setter(Builder::modelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelArn").build()}).build();
    private static final SdkField<Boolean> ENABLE_NETWORK_ISOLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableNetworkIsolation").getter(DescribeModelResponse.getter(DescribeModelResponse::enableNetworkIsolation)).setter(DescribeModelResponse.setter(Builder::enableNetworkIsolation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableNetworkIsolation").build()}).build();
    private static final SdkField<DeploymentRecommendation> DEPLOYMENT_RECOMMENDATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeploymentRecommendation").getter(DescribeModelResponse.getter(DescribeModelResponse::deploymentRecommendation)).setter(DescribeModelResponse.setter(Builder::deploymentRecommendation)).constructor(DeploymentRecommendation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentRecommendation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD, PRIMARY_CONTAINER_FIELD, CONTAINERS_FIELD, INFERENCE_EXECUTION_CONFIG_FIELD, EXECUTION_ROLE_ARN_FIELD, VPC_CONFIG_FIELD, CREATION_TIME_FIELD, MODEL_ARN_FIELD, ENABLE_NETWORK_ISOLATION_FIELD, DEPLOYMENT_RECOMMENDATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeModelResponse.memberNameToFieldInitializer();
    private final String modelName;
    private final ContainerDefinition primaryContainer;
    private final List<ContainerDefinition> containers;
    private final InferenceExecutionConfig inferenceExecutionConfig;
    private final String executionRoleArn;
    private final VpcConfig vpcConfig;
    private final Instant creationTime;
    private final String modelArn;
    private final Boolean enableNetworkIsolation;
    private final DeploymentRecommendation deploymentRecommendation;

    private DescribeModelResponse(BuilderImpl builder) {
        super(builder);
        this.modelName = builder.modelName;
        this.primaryContainer = builder.primaryContainer;
        this.containers = builder.containers;
        this.inferenceExecutionConfig = builder.inferenceExecutionConfig;
        this.executionRoleArn = builder.executionRoleArn;
        this.vpcConfig = builder.vpcConfig;
        this.creationTime = builder.creationTime;
        this.modelArn = builder.modelArn;
        this.enableNetworkIsolation = builder.enableNetworkIsolation;
        this.deploymentRecommendation = builder.deploymentRecommendation;
    }

    public final String modelName() {
        return this.modelName;
    }

    public final ContainerDefinition primaryContainer() {
        return this.primaryContainer;
    }

    public final boolean hasContainers() {
        return this.containers != null && !(this.containers instanceof SdkAutoConstructList);
    }

    public final List<ContainerDefinition> containers() {
        return this.containers;
    }

    public final InferenceExecutionConfig inferenceExecutionConfig() {
        return this.inferenceExecutionConfig;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    public final VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String modelArn() {
        return this.modelArn;
    }

    public final Boolean enableNetworkIsolation() {
        return this.enableNetworkIsolation;
    }

    public final DeploymentRecommendation deploymentRecommendation() {
        return this.deploymentRecommendation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryContainer());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainers() ? this.containers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceExecutionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableNetworkIsolation());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentRecommendation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeModelResponse)) {
            return false;
        }
        DescribeModelResponse other = (DescribeModelResponse)((Object)obj);
        return Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.primaryContainer(), other.primaryContainer()) && this.hasContainers() == other.hasContainers() && Objects.equals(this.containers(), other.containers()) && Objects.equals(this.inferenceExecutionConfig(), other.inferenceExecutionConfig()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.modelArn(), other.modelArn()) && Objects.equals(this.enableNetworkIsolation(), other.enableNetworkIsolation()) && Objects.equals(this.deploymentRecommendation(), other.deploymentRecommendation());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeModelResponse").add("ModelName", (Object)this.modelName()).add("PrimaryContainer", (Object)this.primaryContainer()).add("Containers", this.hasContainers() ? this.containers() : null).add("InferenceExecutionConfig", (Object)this.inferenceExecutionConfig()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("VpcConfig", (Object)this.vpcConfig()).add("CreationTime", (Object)this.creationTime()).add("ModelArn", (Object)this.modelArn()).add("EnableNetworkIsolation", (Object)this.enableNetworkIsolation()).add("DeploymentRecommendation", (Object)this.deploymentRecommendation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
            case "PrimaryContainer": {
                return Optional.ofNullable(clazz.cast(this.primaryContainer()));
            }
            case "Containers": {
                return Optional.ofNullable(clazz.cast(this.containers()));
            }
            case "InferenceExecutionConfig": {
                return Optional.ofNullable(clazz.cast(this.inferenceExecutionConfig()));
            }
            case "ExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "VpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "ModelArn": {
                return Optional.ofNullable(clazz.cast(this.modelArn()));
            }
            case "EnableNetworkIsolation": {
                return Optional.ofNullable(clazz.cast(this.enableNetworkIsolation()));
            }
            case "DeploymentRecommendation": {
                return Optional.ofNullable(clazz.cast(this.deploymentRecommendation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ModelName", MODEL_NAME_FIELD);
        map.put("PrimaryContainer", PRIMARY_CONTAINER_FIELD);
        map.put("Containers", CONTAINERS_FIELD);
        map.put("InferenceExecutionConfig", INFERENCE_EXECUTION_CONFIG_FIELD);
        map.put("ExecutionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("VpcConfig", VPC_CONFIG_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("ModelArn", MODEL_ARN_FIELD);
        map.put("EnableNetworkIsolation", ENABLE_NETWORK_ISOLATION_FIELD);
        map.put("DeploymentRecommendation", DEPLOYMENT_RECOMMENDATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeModelResponse, T> g) {
        return obj -> g.apply((DescribeModelResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String modelName;
        private ContainerDefinition primaryContainer;
        private List<ContainerDefinition> containers = DefaultSdkAutoConstructList.getInstance();
        private InferenceExecutionConfig inferenceExecutionConfig;
        private String executionRoleArn;
        private VpcConfig vpcConfig;
        private Instant creationTime;
        private String modelArn;
        private Boolean enableNetworkIsolation;
        private DeploymentRecommendation deploymentRecommendation;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeModelResponse model) {
            super(model);
            this.modelName(model.modelName);
            this.primaryContainer(model.primaryContainer);
            this.containers(model.containers);
            this.inferenceExecutionConfig(model.inferenceExecutionConfig);
            this.executionRoleArn(model.executionRoleArn);
            this.vpcConfig(model.vpcConfig);
            this.creationTime(model.creationTime);
            this.modelArn(model.modelArn);
            this.enableNetworkIsolation(model.enableNetworkIsolation);
            this.deploymentRecommendation(model.deploymentRecommendation);
        }

        public final String getModelName() {
            return this.modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final ContainerDefinition.Builder getPrimaryContainer() {
            return this.primaryContainer != null ? this.primaryContainer.toBuilder() : null;
        }

        public final void setPrimaryContainer(ContainerDefinition.BuilderImpl primaryContainer) {
            this.primaryContainer = primaryContainer != null ? primaryContainer.build() : null;
        }

        @Override
        public final Builder primaryContainer(ContainerDefinition primaryContainer) {
            this.primaryContainer = primaryContainer;
            return this;
        }

        public final List<ContainerDefinition.Builder> getContainers() {
            List<ContainerDefinition.Builder> result = ContainerDefinitionListCopier.copyToBuilder(this.containers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainers(Collection<ContainerDefinition.BuilderImpl> containers) {
            this.containers = ContainerDefinitionListCopier.copyFromBuilder(containers);
        }

        @Override
        public final Builder containers(Collection<ContainerDefinition> containers) {
            this.containers = ContainerDefinitionListCopier.copy(containers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(ContainerDefinition ... containers) {
            this.containers(Arrays.asList(containers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(Consumer<ContainerDefinition.Builder> ... containers) {
            this.containers(Stream.of(containers).map(c -> (ContainerDefinition)((ContainerDefinition.Builder)ContainerDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final InferenceExecutionConfig.Builder getInferenceExecutionConfig() {
            return this.inferenceExecutionConfig != null ? this.inferenceExecutionConfig.toBuilder() : null;
        }

        public final void setInferenceExecutionConfig(InferenceExecutionConfig.BuilderImpl inferenceExecutionConfig) {
            this.inferenceExecutionConfig = inferenceExecutionConfig != null ? inferenceExecutionConfig.build() : null;
        }

        @Override
        public final Builder inferenceExecutionConfig(InferenceExecutionConfig inferenceExecutionConfig) {
            this.inferenceExecutionConfig = inferenceExecutionConfig;
            return this;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getModelArn() {
            return this.modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final Boolean getEnableNetworkIsolation() {
            return this.enableNetworkIsolation;
        }

        public final void setEnableNetworkIsolation(Boolean enableNetworkIsolation) {
            this.enableNetworkIsolation = enableNetworkIsolation;
        }

        @Override
        public final Builder enableNetworkIsolation(Boolean enableNetworkIsolation) {
            this.enableNetworkIsolation = enableNetworkIsolation;
            return this;
        }

        public final DeploymentRecommendation.Builder getDeploymentRecommendation() {
            return this.deploymentRecommendation != null ? this.deploymentRecommendation.toBuilder() : null;
        }

        public final void setDeploymentRecommendation(DeploymentRecommendation.BuilderImpl deploymentRecommendation) {
            this.deploymentRecommendation = deploymentRecommendation != null ? deploymentRecommendation.build() : null;
        }

        @Override
        public final Builder deploymentRecommendation(DeploymentRecommendation deploymentRecommendation) {
            this.deploymentRecommendation = deploymentRecommendation;
            return this;
        }

        @Override
        public DescribeModelResponse build() {
            return new DescribeModelResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeModelResponse> {
        public Builder modelName(String var1);

        public Builder primaryContainer(ContainerDefinition var1);

        default public Builder primaryContainer(Consumer<ContainerDefinition.Builder> primaryContainer) {
            return this.primaryContainer((ContainerDefinition)((ContainerDefinition.Builder)ContainerDefinition.builder().applyMutation(primaryContainer)).build());
        }

        public Builder containers(Collection<ContainerDefinition> var1);

        public Builder containers(ContainerDefinition ... var1);

        public Builder containers(Consumer<ContainerDefinition.Builder> ... var1);

        public Builder inferenceExecutionConfig(InferenceExecutionConfig var1);

        default public Builder inferenceExecutionConfig(Consumer<InferenceExecutionConfig.Builder> inferenceExecutionConfig) {
            return this.inferenceExecutionConfig((InferenceExecutionConfig)((InferenceExecutionConfig.Builder)InferenceExecutionConfig.builder().applyMutation(inferenceExecutionConfig)).build());
        }

        public Builder executionRoleArn(String var1);

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder modelArn(String var1);

        public Builder enableNetworkIsolation(Boolean var1);

        public Builder deploymentRecommendation(DeploymentRecommendation var1);

        default public Builder deploymentRecommendation(Consumer<DeploymentRecommendation.Builder> deploymentRecommendation) {
            return this.deploymentRecommendation((DeploymentRecommendation)((DeploymentRecommendation.Builder)DeploymentRecommendation.builder().applyMutation(deploymentRecommendation)).build());
        }
    }
}

