/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ClusterStatus;
import software.amazon.awssdk.services.sagemaker.model.TrainingPlanArnsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusterSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClusterSummary> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterArn").getter(ClusterSummary.getter(ClusterSummary::clusterArn)).setter(ClusterSummary.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterArn").build()}).build();
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterName").getter(ClusterSummary.getter(ClusterSummary::clusterName)).setter(ClusterSummary.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterName").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(ClusterSummary.getter(ClusterSummary::creationTime)).setter(ClusterSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> CLUSTER_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterStatus").getter(ClusterSummary.getter(ClusterSummary::clusterStatusAsString)).setter(ClusterSummary.setter(Builder::clusterStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterStatus").build()}).build();
    private static final SdkField<List<String>> TRAINING_PLAN_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TrainingPlanArns").getter(ClusterSummary.getter(ClusterSummary::trainingPlanArns)).setter(ClusterSummary.setter(Builder::trainingPlanArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingPlanArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD, CLUSTER_NAME_FIELD, CREATION_TIME_FIELD, CLUSTER_STATUS_FIELD, TRAINING_PLAN_ARNS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ClusterSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String clusterArn;
    private final String clusterName;
    private final Instant creationTime;
    private final String clusterStatus;
    private final List<String> trainingPlanArns;

    private ClusterSummary(BuilderImpl builder) {
        this.clusterArn = builder.clusterArn;
        this.clusterName = builder.clusterName;
        this.creationTime = builder.creationTime;
        this.clusterStatus = builder.clusterStatus;
        this.trainingPlanArns = builder.trainingPlanArns;
    }

    public final String clusterArn() {
        return this.clusterArn;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final ClusterStatus clusterStatus() {
        return ClusterStatus.fromValue(this.clusterStatus);
    }

    public final String clusterStatusAsString() {
        return this.clusterStatus;
    }

    public final boolean hasTrainingPlanArns() {
        return this.trainingPlanArns != null && !(this.trainingPlanArns instanceof SdkAutoConstructList);
    }

    public final List<String> trainingPlanArns() {
        return this.trainingPlanArns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrainingPlanArns() ? this.trainingPlanArns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterSummary)) {
            return false;
        }
        ClusterSummary other = (ClusterSummary)obj;
        return Objects.equals(this.clusterArn(), other.clusterArn()) && Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.clusterStatusAsString(), other.clusterStatusAsString()) && this.hasTrainingPlanArns() == other.hasTrainingPlanArns() && Objects.equals(this.trainingPlanArns(), other.trainingPlanArns());
    }

    public final String toString() {
        return ToString.builder((String)"ClusterSummary").add("ClusterArn", (Object)this.clusterArn()).add("ClusterName", (Object)this.clusterName()).add("CreationTime", (Object)this.creationTime()).add("ClusterStatus", (Object)this.clusterStatusAsString()).add("TrainingPlanArns", this.hasTrainingPlanArns() ? this.trainingPlanArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "ClusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "ClusterStatus": {
                return Optional.ofNullable(clazz.cast(this.clusterStatusAsString()));
            }
            case "TrainingPlanArns": {
                return Optional.ofNullable(clazz.cast(this.trainingPlanArns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClusterArn", CLUSTER_ARN_FIELD);
        map.put("ClusterName", CLUSTER_NAME_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("ClusterStatus", CLUSTER_STATUS_FIELD);
        map.put("TrainingPlanArns", TRAINING_PLAN_ARNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClusterSummary, T> g) {
        return obj -> g.apply((ClusterSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterArn;
        private String clusterName;
        private Instant creationTime;
        private String clusterStatus;
        private List<String> trainingPlanArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterSummary model) {
            this.clusterArn(model.clusterArn);
            this.clusterName(model.clusterName);
            this.creationTime(model.creationTime);
            this.clusterStatus(model.clusterStatus);
            this.trainingPlanArns(model.trainingPlanArns);
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getClusterStatus() {
            return this.clusterStatus;
        }

        public final void setClusterStatus(String clusterStatus) {
            this.clusterStatus = clusterStatus;
        }

        @Override
        public final Builder clusterStatus(String clusterStatus) {
            this.clusterStatus = clusterStatus;
            return this;
        }

        @Override
        public final Builder clusterStatus(ClusterStatus clusterStatus) {
            this.clusterStatus(clusterStatus == null ? null : clusterStatus.toString());
            return this;
        }

        public final Collection<String> getTrainingPlanArns() {
            if (this.trainingPlanArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.trainingPlanArns;
        }

        public final void setTrainingPlanArns(Collection<String> trainingPlanArns) {
            this.trainingPlanArns = TrainingPlanArnsCopier.copy(trainingPlanArns);
        }

        @Override
        public final Builder trainingPlanArns(Collection<String> trainingPlanArns) {
            this.trainingPlanArns = TrainingPlanArnsCopier.copy(trainingPlanArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trainingPlanArns(String ... trainingPlanArns) {
            this.trainingPlanArns(Arrays.asList(trainingPlanArns));
            return this;
        }

        public ClusterSummary build() {
            return new ClusterSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClusterSummary> {
        public Builder clusterArn(String var1);

        public Builder clusterName(String var1);

        public Builder creationTime(Instant var1);

        public Builder clusterStatus(String var1);

        public Builder clusterStatus(ClusterStatus var1);

        public Builder trainingPlanArns(Collection<String> var1);

        public Builder trainingPlanArns(String ... var1);
    }
}

