/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.AutoMLAlgorithm;
import software.amazon.awssdk.services.sagemaker.model.AutoMLAlgorithmsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoMLAlgorithmConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoMLAlgorithmConfig> {
    private static final SdkField<List<String>> AUTO_ML_ALGORITHMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AutoMLAlgorithms").getter(AutoMLAlgorithmConfig.getter(AutoMLAlgorithmConfig::autoMLAlgorithmsAsStrings)).setter(AutoMLAlgorithmConfig.setter(Builder::autoMLAlgorithmsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLAlgorithms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_ML_ALGORITHMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutoMLAlgorithmConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> autoMLAlgorithms;

    private AutoMLAlgorithmConfig(BuilderImpl builder) {
        this.autoMLAlgorithms = builder.autoMLAlgorithms;
    }

    public final List<AutoMLAlgorithm> autoMLAlgorithms() {
        return AutoMLAlgorithmsCopier.copyStringToEnum(this.autoMLAlgorithms);
    }

    public final boolean hasAutoMLAlgorithms() {
        return this.autoMLAlgorithms != null && !(this.autoMLAlgorithms instanceof SdkAutoConstructList);
    }

    public final List<String> autoMLAlgorithmsAsStrings() {
        return this.autoMLAlgorithms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAutoMLAlgorithms() ? this.autoMLAlgorithmsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoMLAlgorithmConfig)) {
            return false;
        }
        AutoMLAlgorithmConfig other = (AutoMLAlgorithmConfig)obj;
        return this.hasAutoMLAlgorithms() == other.hasAutoMLAlgorithms() && Objects.equals(this.autoMLAlgorithmsAsStrings(), other.autoMLAlgorithmsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"AutoMLAlgorithmConfig").add("AutoMLAlgorithms", this.hasAutoMLAlgorithms() ? this.autoMLAlgorithmsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoMLAlgorithms": {
                return Optional.ofNullable(clazz.cast(this.autoMLAlgorithmsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("AutoMLAlgorithms", AUTO_ML_ALGORITHMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutoMLAlgorithmConfig, T> g) {
        return obj -> g.apply((AutoMLAlgorithmConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> autoMLAlgorithms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutoMLAlgorithmConfig model) {
            this.autoMLAlgorithmsWithStrings(model.autoMLAlgorithms);
        }

        public final Collection<String> getAutoMLAlgorithms() {
            if (this.autoMLAlgorithms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.autoMLAlgorithms;
        }

        public final void setAutoMLAlgorithms(Collection<String> autoMLAlgorithms) {
            this.autoMLAlgorithms = AutoMLAlgorithmsCopier.copy(autoMLAlgorithms);
        }

        @Override
        public final Builder autoMLAlgorithmsWithStrings(Collection<String> autoMLAlgorithms) {
            this.autoMLAlgorithms = AutoMLAlgorithmsCopier.copy(autoMLAlgorithms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoMLAlgorithmsWithStrings(String ... autoMLAlgorithms) {
            this.autoMLAlgorithmsWithStrings(Arrays.asList(autoMLAlgorithms));
            return this;
        }

        @Override
        public final Builder autoMLAlgorithms(Collection<AutoMLAlgorithm> autoMLAlgorithms) {
            this.autoMLAlgorithms = AutoMLAlgorithmsCopier.copyEnumToString(autoMLAlgorithms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoMLAlgorithms(AutoMLAlgorithm ... autoMLAlgorithms) {
            this.autoMLAlgorithms(Arrays.asList(autoMLAlgorithms));
            return this;
        }

        public AutoMLAlgorithmConfig build() {
            return new AutoMLAlgorithmConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoMLAlgorithmConfig> {
        public Builder autoMLAlgorithmsWithStrings(Collection<String> var1);

        public Builder autoMLAlgorithmsWithStrings(String ... var1);

        public Builder autoMLAlgorithms(Collection<AutoMLAlgorithm> var1);

        public Builder autoMLAlgorithms(AutoMLAlgorithm ... var1);
    }
}

