/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AssemblyType {
    NONE("None"),
    LINE("Line"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AssemblyType> VALUE_MAP;
    private final String value;

    private AssemblyType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AssemblyType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AssemblyType> knownValues() {
        EnumSet<AssemblyType> knownValues = EnumSet.allOf(AssemblyType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AssemblyType.class, AssemblyType::toString);
    }
}

