/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.LabelingJobForWorkteamSummary;
import software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsForWorkteamRequest;
import software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsForWorkteamResponse;

public class ListLabelingJobsForWorkteamIterable
implements SdkIterable<ListLabelingJobsForWorkteamResponse> {
    private final SageMakerClient client;
    private final ListLabelingJobsForWorkteamRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLabelingJobsForWorkteamIterable(SageMakerClient client, ListLabelingJobsForWorkteamRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListLabelingJobsForWorkteamResponseFetcher();
    }

    public Iterator<ListLabelingJobsForWorkteamResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LabelingJobForWorkteamSummary> labelingJobSummaryList() {
        Function<ListLabelingJobsForWorkteamResponse, Iterator> getIterator = response -> {
            if (response != null && response.labelingJobSummaryList() != null) {
                return response.labelingJobSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListLabelingJobsForWorkteamResponseFetcher
    implements SyncPageFetcher<ListLabelingJobsForWorkteamResponse> {
        private ListLabelingJobsForWorkteamResponseFetcher() {
        }

        public boolean hasNextPage(ListLabelingJobsForWorkteamResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLabelingJobsForWorkteamResponse nextPage(ListLabelingJobsForWorkteamResponse previousPage) {
            if (previousPage == null) {
                return ListLabelingJobsForWorkteamIterable.this.client.listLabelingJobsForWorkteam(ListLabelingJobsForWorkteamIterable.this.firstRequest);
            }
            return ListLabelingJobsForWorkteamIterable.this.client.listLabelingJobsForWorkteam((ListLabelingJobsForWorkteamRequest)((Object)ListLabelingJobsForWorkteamIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

