/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.HumanTaskUiSummary;
import software.amazon.awssdk.services.sagemaker.model.ListHumanTaskUisRequest;
import software.amazon.awssdk.services.sagemaker.model.ListHumanTaskUisResponse;

public class ListHumanTaskUisIterable
implements SdkIterable<ListHumanTaskUisResponse> {
    private final SageMakerClient client;
    private final ListHumanTaskUisRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListHumanTaskUisIterable(SageMakerClient client, ListHumanTaskUisRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListHumanTaskUisResponseFetcher();
    }

    public Iterator<ListHumanTaskUisResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<HumanTaskUiSummary> humanTaskUiSummaries() {
        Function<ListHumanTaskUisResponse, Iterator> getIterator = response -> {
            if (response != null && response.humanTaskUiSummaries() != null) {
                return response.humanTaskUiSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListHumanTaskUisResponseFetcher
    implements SyncPageFetcher<ListHumanTaskUisResponse> {
        private ListHumanTaskUisResponseFetcher() {
        }

        public boolean hasNextPage(ListHumanTaskUisResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListHumanTaskUisResponse nextPage(ListHumanTaskUisResponse previousPage) {
            if (previousPage == null) {
                return ListHumanTaskUisIterable.this.client.listHumanTaskUis(ListHumanTaskUisIterable.this.firstRequest);
            }
            return ListHumanTaskUisIterable.this.client.listHumanTaskUis((ListHumanTaskUisRequest)((Object)ListHumanTaskUisIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

