/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ImageVersionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageVersion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageVersion> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(ImageVersion.getter(ImageVersion::creationTime)).setter(ImageVersion.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(ImageVersion.getter(ImageVersion::failureReason)).setter(ImageVersion.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<String> IMAGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageArn").getter(ImageVersion.getter(ImageVersion::imageArn)).setter(ImageVersion.setter(Builder::imageArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageArn").build()}).build();
    private static final SdkField<String> IMAGE_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageVersionArn").getter(ImageVersion.getter(ImageVersion::imageVersionArn)).setter(ImageVersion.setter(Builder::imageVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageVersionArn").build()}).build();
    private static final SdkField<String> IMAGE_VERSION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageVersionStatus").getter(ImageVersion.getter(ImageVersion::imageVersionStatusAsString)).setter(ImageVersion.setter(Builder::imageVersionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageVersionStatus").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(ImageVersion.getter(ImageVersion::lastModifiedTime)).setter(ImageVersion.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<Integer> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Version").getter(ImageVersion.getter(ImageVersion::version)).setter(ImageVersion.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD, FAILURE_REASON_FIELD, IMAGE_ARN_FIELD, IMAGE_VERSION_ARN_FIELD, IMAGE_VERSION_STATUS_FIELD, LAST_MODIFIED_TIME_FIELD, VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImageVersion.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant creationTime;
    private final String failureReason;
    private final String imageArn;
    private final String imageVersionArn;
    private final String imageVersionStatus;
    private final Instant lastModifiedTime;
    private final Integer version;

    private ImageVersion(BuilderImpl builder) {
        this.creationTime = builder.creationTime;
        this.failureReason = builder.failureReason;
        this.imageArn = builder.imageArn;
        this.imageVersionArn = builder.imageVersionArn;
        this.imageVersionStatus = builder.imageVersionStatus;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.version = builder.version;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final String imageArn() {
        return this.imageArn;
    }

    public final String imageVersionArn() {
        return this.imageVersionArn;
    }

    public final ImageVersionStatus imageVersionStatus() {
        return ImageVersionStatus.fromValue(this.imageVersionStatus);
    }

    public final String imageVersionStatusAsString() {
        return this.imageVersionStatus;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final Integer version() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageVersionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageVersion)) {
            return false;
        }
        ImageVersion other = (ImageVersion)obj;
        return Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.imageArn(), other.imageArn()) && Objects.equals(this.imageVersionArn(), other.imageVersionArn()) && Objects.equals(this.imageVersionStatusAsString(), other.imageVersionStatusAsString()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.version(), other.version());
    }

    public final String toString() {
        return ToString.builder((String)"ImageVersion").add("CreationTime", (Object)this.creationTime()).add("FailureReason", (Object)this.failureReason()).add("ImageArn", (Object)this.imageArn()).add("ImageVersionArn", (Object)this.imageVersionArn()).add("ImageVersionStatus", (Object)this.imageVersionStatusAsString()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("Version", (Object)this.version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "ImageArn": {
                return Optional.ofNullable(clazz.cast(this.imageArn()));
            }
            case "ImageVersionArn": {
                return Optional.ofNullable(clazz.cast(this.imageVersionArn()));
            }
            case "ImageVersionStatus": {
                return Optional.ofNullable(clazz.cast(this.imageVersionStatusAsString()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        map.put("ImageArn", IMAGE_ARN_FIELD);
        map.put("ImageVersionArn", IMAGE_VERSION_ARN_FIELD);
        map.put("ImageVersionStatus", IMAGE_VERSION_STATUS_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("Version", VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageVersion, T> g) {
        return obj -> g.apply((ImageVersion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant creationTime;
        private String failureReason;
        private String imageArn;
        private String imageVersionArn;
        private String imageVersionStatus;
        private Instant lastModifiedTime;
        private Integer version;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageVersion model) {
            this.creationTime(model.creationTime);
            this.failureReason(model.failureReason);
            this.imageArn(model.imageArn);
            this.imageVersionArn(model.imageVersionArn);
            this.imageVersionStatus(model.imageVersionStatus);
            this.lastModifiedTime(model.lastModifiedTime);
            this.version(model.version);
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getImageArn() {
            return this.imageArn;
        }

        public final void setImageArn(String imageArn) {
            this.imageArn = imageArn;
        }

        @Override
        public final Builder imageArn(String imageArn) {
            this.imageArn = imageArn;
            return this;
        }

        public final String getImageVersionArn() {
            return this.imageVersionArn;
        }

        public final void setImageVersionArn(String imageVersionArn) {
            this.imageVersionArn = imageVersionArn;
        }

        @Override
        public final Builder imageVersionArn(String imageVersionArn) {
            this.imageVersionArn = imageVersionArn;
            return this;
        }

        public final String getImageVersionStatus() {
            return this.imageVersionStatus;
        }

        public final void setImageVersionStatus(String imageVersionStatus) {
            this.imageVersionStatus = imageVersionStatus;
        }

        @Override
        public final Builder imageVersionStatus(String imageVersionStatus) {
            this.imageVersionStatus = imageVersionStatus;
            return this;
        }

        @Override
        public final Builder imageVersionStatus(ImageVersionStatus imageVersionStatus) {
            this.imageVersionStatus(imageVersionStatus == null ? null : imageVersionStatus.toString());
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Integer getVersion() {
            return this.version;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public ImageVersion build() {
            return new ImageVersion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageVersion> {
        public Builder creationTime(Instant var1);

        public Builder failureReason(String var1);

        public Builder imageArn(String var1);

        public Builder imageVersionArn(String var1);

        public Builder imageVersionStatus(String var1);

        public Builder imageVersionStatus(ImageVersionStatus var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder version(Integer var1);
    }
}

