/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsResponse;

public class ListLabelingJobsPublisher
implements SdkPublisher<ListLabelingJobsResponse> {
    private final SageMakerAsyncClient client;
    private final ListLabelingJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLabelingJobsPublisher(SageMakerAsyncClient client, ListLabelingJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLabelingJobsPublisher(SageMakerAsyncClient client, ListLabelingJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLabelingJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLabelingJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListLabelingJobsPublisher resume(ListLabelingJobsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListLabelingJobsPublisher(this.client, (ListLabelingJobsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListLabelingJobsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListLabelingJobsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListLabelingJobsResponseFetcher
    implements AsyncPageFetcher<ListLabelingJobsResponse> {
        private ListLabelingJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListLabelingJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListLabelingJobsResponse> nextPage(ListLabelingJobsResponse previousPage) {
            if (previousPage == null) {
                return ListLabelingJobsPublisher.this.client.listLabelingJobs(ListLabelingJobsPublisher.this.firstRequest);
            }
            return ListLabelingJobsPublisher.this.client.listLabelingJobs((ListLabelingJobsRequest)((Object)ListLabelingJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

