/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.model.ListSubscribedWorkteamsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListSubscribedWorkteamsResponse;

public class ListSubscribedWorkteamsPublisher
implements SdkPublisher<ListSubscribedWorkteamsResponse> {
    private final SageMakerAsyncClient client;
    private final ListSubscribedWorkteamsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSubscribedWorkteamsPublisher(SageMakerAsyncClient client, ListSubscribedWorkteamsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSubscribedWorkteamsPublisher(SageMakerAsyncClient client, ListSubscribedWorkteamsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSubscribedWorkteamsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSubscribedWorkteamsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListSubscribedWorkteamsPublisher resume(ListSubscribedWorkteamsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListSubscribedWorkteamsPublisher(this.client, (ListSubscribedWorkteamsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListSubscribedWorkteamsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListSubscribedWorkteamsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListSubscribedWorkteamsResponseFetcher
    implements AsyncPageFetcher<ListSubscribedWorkteamsResponse> {
        private ListSubscribedWorkteamsResponseFetcher() {
        }

        public boolean hasNextPage(ListSubscribedWorkteamsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSubscribedWorkteamsResponse> nextPage(ListSubscribedWorkteamsResponse previousPage) {
            if (previousPage == null) {
                return ListSubscribedWorkteamsPublisher.this.client.listSubscribedWorkteams(ListSubscribedWorkteamsPublisher.this.firstRequest);
            }
            return ListSubscribedWorkteamsPublisher.this.client.listSubscribedWorkteams((ListSubscribedWorkteamsRequest)((Object)ListSubscribedWorkteamsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

